/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.ably.lib.objects.Binary;
import io.ably.lib.objects.ErrorCode;
import io.ably.lib.objects.HttpStatusCode;
import io.ably.lib.objects.ObjectData;
import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectOperationAction;
import io.ably.lib.objects.ObjectState;
import io.ably.lib.objects.ObjectValue;
import io.ably.lib.objects.ObjectsCounter;
import io.ably.lib.objects.ObjectsCounterOp;
import io.ably.lib.objects.ObjectsMap;
import io.ably.lib.objects.ObjectsMapEntry;
import io.ably.lib.objects.ObjectsMapOp;
import io.ably.lib.objects.ObjectsMapSemantics;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.util.Serialisation;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"writeMsgpack", "", "Lio/ably/lib/objects/ObjectMessage;", "packer", "Lorg/msgpack/core/MessagePacker;", "readObjectMessage", "unpacker", "Lorg/msgpack/core/MessageUnpacker;", "Lio/ably/lib/objects/ObjectOperation;", "readObjectOperation", "Lio/ably/lib/objects/ObjectState;", "readObjectState", "Lio/ably/lib/objects/ObjectsMapOp;", "readObjectMapOp", "Lio/ably/lib/objects/ObjectsCounterOp;", "readObjectCounterOp", "Lio/ably/lib/objects/ObjectsMap;", "readObjectMap", "Lio/ably/lib/objects/ObjectsCounter;", "readObjectCounter", "Lio/ably/lib/objects/ObjectsMapEntry;", "readObjectMapEntry", "Lio/ably/lib/objects/ObjectData;", "readObjectData", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nMsgpackSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsgpackSerialization.kt\nio/ably/lib/objects/serialization/MsgpackSerializationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,719:1\n1#2:720\n295#3,2:721\n295#3,2:723\n295#3,2:725\n295#3,2:727\n*S KotlinDebug\n*F\n+ 1 MsgpackSerialization.kt\nio/ably/lib/objects/serialization/MsgpackSerializationKt\n*L\n237#1:721,2\n238#1:723,2\n497#1:725,2\n498#1:727,2\n*E\n"})
public final class MsgpackSerializationKt {
    public static final void writeMsgpack(@NotNull ObjectMessage $this$writeMsgpack, @NotNull MessagePacker packer) {
        Intrinsics.checkNotNullParameter((Object)$this$writeMsgpack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packer, (String)"packer");
        int fieldCount = 0;
        if ($this$writeMsgpack.getId() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getTimestamp() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getClientId() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getConnectionId() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getExtras() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getOperation() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getObjectState() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getSerial() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getSerialTimestamp() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getSiteCode() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if ($this$writeMsgpack.getId() != null) {
            packer.packString("id");
            packer.packString($this$writeMsgpack.getId());
        }
        if ($this$writeMsgpack.getTimestamp() != null) {
            packer.packString("timestamp");
            packer.packLong($this$writeMsgpack.getTimestamp().longValue());
        }
        if ($this$writeMsgpack.getClientId() != null) {
            packer.packString("clientId");
            packer.packString($this$writeMsgpack.getClientId());
        }
        if ($this$writeMsgpack.getConnectionId() != null) {
            packer.packString("connectionId");
            packer.packString($this$writeMsgpack.getConnectionId());
        }
        if ($this$writeMsgpack.getExtras() != null) {
            packer.packString("extras");
            packer.writePayload(Serialisation.gsonToMsgpack((JsonElement)((JsonElement)$this$writeMsgpack.getExtras())));
        }
        if ($this$writeMsgpack.getOperation() != null) {
            packer.packString("operation");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getOperation(), packer);
        }
        if ($this$writeMsgpack.getObjectState() != null) {
            packer.packString("object");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getObjectState(), packer);
        }
        if ($this$writeMsgpack.getSerial() != null) {
            packer.packString("serial");
            packer.packString($this$writeMsgpack.getSerial());
        }
        if ($this$writeMsgpack.getSerialTimestamp() != null) {
            packer.packString("serialTimestamp");
            packer.packLong($this$writeMsgpack.getSerialTimestamp().longValue());
        }
        if ($this$writeMsgpack.getSiteCode() != null) {
            packer.packString("siteCode");
            packer.packString($this$writeMsgpack.getSiteCode());
        }
    }

    @NotNull
    public static final ObjectMessage readObjectMessage(@NotNull MessageUnpacker unpacker) {
        Intrinsics.checkNotNullParameter((Object)unpacker, (String)"unpacker");
        if (unpacker.getNextFormat() == MessageFormat.NIL) {
            unpacker.unpackNil();
            return new ObjectMessage(null, null, null, null, null, null, null, null, null, null, 1023, null);
        }
        int fieldCount = unpacker.unpackMapHeader();
        String id = null;
        Long timestamp = null;
        String clientId = null;
        String connectionId = null;
        JsonObject extras = null;
        ObjectOperation operation = null;
        ObjectState objectState = null;
        String serial = null;
        Long serialTimestamp = null;
        String siteCode = null;
        block24: for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            String string = unpacker.unpackString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unpackString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.intern(), (String)"intern(...)");
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat == MessageFormat.NIL) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "id": {
                    id = unpacker.unpackString();
                    continue block24;
                }
                case "timestamp": {
                    timestamp = unpacker.unpackLong();
                    continue block24;
                }
                case "clientId": {
                    clientId = unpacker.unpackString();
                    continue block24;
                }
                case "connectionId": {
                    connectionId = unpacker.unpackString();
                    continue block24;
                }
                case "extras": {
                    JsonElement jsonElement = Serialisation.msgpackToGson((Value)((Value)unpacker.unpackValue()));
                    extras = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
                    continue block24;
                }
                case "operation": {
                    operation = MsgpackSerializationKt.readObjectOperation(unpacker);
                    continue block24;
                }
                case "object": {
                    objectState = MsgpackSerializationKt.readObjectState(unpacker);
                    continue block24;
                }
                case "serial": {
                    serial = unpacker.unpackString();
                    continue block24;
                }
                case "serialTimestamp": {
                    serialTimestamp = unpacker.unpackLong();
                    continue block24;
                }
                case "siteCode": {
                    siteCode = unpacker.unpackString();
                    continue block24;
                }
                default: {
                    unpacker.skipValue();
                }
            }
        }
        return new ObjectMessage(id, timestamp, clientId, connectionId, extras, operation, objectState, serial, serialTimestamp, siteCode);
    }

    private static final void writeMsgpack(ObjectOperation $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 1;
        if (!(((CharSequence)$this$writeMsgpack.getObjectId()).length() > 0)) {
            boolean bl = false;
            String string = "objectId must be non-empty per Objects protocol";
            throw new IllegalArgumentException(string.toString());
        }
        ++fieldCount;
        if ($this$writeMsgpack.getMapOp() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getCounterOp() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getMap() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getCounter() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getNonce() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getInitialValue() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        packer.packString("action");
        packer.packInt($this$writeMsgpack.getAction().getCode());
        packer.packString("objectId");
        packer.packString($this$writeMsgpack.getObjectId());
        if ($this$writeMsgpack.getMapOp() != null) {
            packer.packString("mapOp");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getMapOp(), packer);
        }
        if ($this$writeMsgpack.getCounterOp() != null) {
            packer.packString("counterOp");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getCounterOp(), packer);
        }
        if ($this$writeMsgpack.getMap() != null) {
            packer.packString("map");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getMap(), packer);
        }
        if ($this$writeMsgpack.getCounter() != null) {
            packer.packString("counter");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getCounter(), packer);
        }
        if ($this$writeMsgpack.getNonce() != null) {
            packer.packString("nonce");
            packer.packString($this$writeMsgpack.getNonce());
        }
        if ($this$writeMsgpack.getInitialValue() != null) {
            packer.packString("initialValue");
            packer.packString($this$writeMsgpack.getInitialValue());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final ObjectOperation readObjectOperation(MessageUnpacker unpacker) {
        fieldCount = unpacker.unpackMapHeader();
        action = null;
        objectId = "";
        mapOp = null;
        counterOp = null;
        map = null;
        counter = null;
        nonce = null;
        initialValue = null;
        block20: for (i = 0; i < fieldCount; ++i) {
            v0 = unpacker.unpackString();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"unpackString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)v0.intern(), (String)"intern(...)");
            fieldFormat = unpacker.getNextFormat();
            if (fieldFormat == MessageFormat.NIL) {
                unpacker.unpackNil();
                continue;
            }
            var13_13 = fieldName;
            tmp = -1;
            switch (var13_13.hashCode()) {
                case 103663709: {
                    if (var13_13.equals("mapOp")) {
                        tmp = 1;
                    }
                    break;
                }
                case 1352257789: {
                    if (var13_13.equals("counterOp")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1422950858: {
                    if (var13_13.equals("action")) {
                        tmp = 3;
                    }
                    break;
                }
                case 957830652: {
                    if (var13_13.equals("counter")) {
                        tmp = 4;
                    }
                    break;
                }
                case 107868: {
                    if (var13_13.equals("map")) {
                        tmp = 5;
                    }
                    break;
                }
                case 105002991: {
                    if (var13_13.equals("nonce")) {
                        tmp = 6;
                    }
                    break;
                }
                case -418368371: {
                    if (var13_13.equals("initialValue")) {
                        tmp = 7;
                    }
                    break;
                }
                case 90495162: {
                    if (var13_13.equals("objectId")) {
                        tmp = 8;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    actionCode = unpacker.unpackInt();
                    $this$firstOrNull$iv = (Iterable)ObjectOperationAction.getEntries();
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (ObjectOperationAction)element$iv;
                        $i$a$-firstOrNull-MsgpackSerializationKt$readObjectOperation$1 = false;
                        if (!(it.getCode() == actionCode)) continue;
                        v1 = element$iv;
                        ** GOTO lbl75
                    }
                    v1 = null;
lbl75:
                    // 2 sources

                    if ((v2 = (ObjectOperationAction)v1) != null) ** GOTO lbl87
                    $this$firstOrNull$iv = (Iterable)ObjectOperationAction.getEntries();
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (ObjectOperationAction)element$iv;
                        $i$a$-firstOrNull-MsgpackSerializationKt$readObjectOperation$2 = false;
                        if (!(it.getCode() == -1)) continue;
                        v3 = element$iv;
                        ** GOTO lbl85
                    }
                    v3 = null;
lbl85:
                    // 2 sources

                    if ((v2 = (ObjectOperationAction)v3) == null) {
                        throw UtilsKt.objectError$default("Unknown ObjectOperationAction code: " + actionCode + " and no Unknown fallback found", null, 2, null);
                    }
lbl87:
                    // 3 sources

                    action = v2;
                    continue block20;
                }
                case 8: {
                    objectId = unpacker.unpackString();
                    continue block20;
                }
                case 1: {
                    mapOp = MsgpackSerializationKt.readObjectMapOp(unpacker);
                    continue block20;
                }
                case 2: {
                    counterOp = MsgpackSerializationKt.readObjectCounterOp(unpacker);
                    continue block20;
                }
                case 5: {
                    map = MsgpackSerializationKt.readObjectMap(unpacker);
                    continue block20;
                }
                case 4: {
                    counter = MsgpackSerializationKt.readObjectCounter(unpacker);
                    continue block20;
                }
                case 6: {
                    nonce = unpacker.unpackString();
                    continue block20;
                }
                case 7: {
                    initialValue = unpacker.unpackString();
                    continue block20;
                }
                default: {
                    unpacker.skipValue();
                }
            }
        }
        if (action == null) {
            throw UtilsKt.objectError$default("Missing required 'action' field in ObjectOperation", null, 2, null);
        }
        return new ObjectOperation(action, objectId, mapOp, counterOp, map, counter, nonce, initialValue);
    }

    private static final void writeMsgpack(ObjectState $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 3;
        if ($this$writeMsgpack.getCreateOp() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getMap() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getCounter() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        packer.packString("objectId");
        packer.packString($this$writeMsgpack.getObjectId());
        packer.packString("siteTimeserials");
        packer.packMapHeader($this$writeMsgpack.getSiteTimeserials().size());
        for (Map.Entry<String, String> entry : $this$writeMsgpack.getSiteTimeserials().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            packer.packString(key);
            packer.packString(value);
        }
        packer.packString("tombstone");
        packer.packBoolean($this$writeMsgpack.getTombstone());
        if ($this$writeMsgpack.getCreateOp() != null) {
            packer.packString("createOp");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getCreateOp(), packer);
        }
        if ($this$writeMsgpack.getMap() != null) {
            packer.packString("map");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getMap(), packer);
        }
        if ($this$writeMsgpack.getCounter() != null) {
            packer.packString("counter");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getCounter(), packer);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final ObjectState readObjectState(MessageUnpacker unpacker) {
        fieldCount = unpacker.unpackMapHeader();
        objectId = "";
        siteTimeserials = MapsKt.emptyMap();
        tombstone = false;
        createOp = null;
        map = null;
        counter = null;
        block8: for (i = 0; i < fieldCount; ++i) {
            block16: {
                block18: {
                    block17: {
                        block15: {
                            v0 = unpacker.unpackString();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"unpackString(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)v0.intern(), (String)"intern(...)");
                            fieldFormat = unpacker.getNextFormat();
                            if (fieldFormat == MessageFormat.NIL) {
                                unpacker.unpackNil();
                                continue;
                            }
                            var11_11 = fieldName;
                            switch (var11_11.hashCode()) {
                                case -1101044789: {
                                    if (var11_11.equals("siteTimeserials")) break;
                                    ** break;
                                }
                                case 1836179733: {
                                    if (!var11_11.equals("tombstone")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                                case 957830652: {
                                    if (!var11_11.equals("counter")) {
                                        ** break;
                                    }
                                    break block16;
                                }
                                case 1820417021: {
                                    if (!var11_11.equals("createOp")) {
                                        ** break;
                                    }
                                    break block17;
                                }
                                case 107868: {
                                    if (!var11_11.equals("map")) {
                                        ** break;
                                    }
                                    break block18;
                                }
                                case 90495162: {
                                    if (!var11_11.equals("objectId")) ** break;
                                    objectId = unpacker.unpackString();
                                    continue block8;
                                }
                            }
                            mapSize = unpacker.unpackMapHeader();
                            tempMap = new LinkedHashMap<K, V>();
                            for (j = 0; j < mapSize; ++j) {
                                key = unpacker.unpackString();
                                value = unpacker.unpackString();
                                tempMap.put(key, value);
                            }
                            siteTimeserials = tempMap;
                            continue;
                        }
                        tombstone = unpacker.unpackBoolean();
                        continue;
                    }
                    createOp = MsgpackSerializationKt.readObjectOperation(unpacker);
                    continue;
                }
                map = MsgpackSerializationKt.readObjectMap(unpacker);
                continue;
            }
            counter = MsgpackSerializationKt.readObjectCounter(unpacker);
            continue;
lbl63:
            // 7 sources

            unpacker.skipValue();
        }
        return new ObjectState(objectId, siteTimeserials, tombstone, createOp, map, counter);
    }

    private static final void writeMsgpack(ObjectsMapOp $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 1;
        if ($this$writeMsgpack.getData() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        packer.packString("key");
        packer.packString($this$writeMsgpack.getKey());
        if ($this$writeMsgpack.getData() != null) {
            packer.packString("data");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getData(), packer);
        }
    }

    private static final ObjectsMapOp readObjectMapOp(MessageUnpacker unpacker) {
        int fieldCount = unpacker.unpackMapHeader();
        String key = "";
        ObjectData data = null;
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            String string = unpacker.unpackString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unpackString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.intern(), (String)"intern(...)");
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat == MessageFormat.NIL) {
                unpacker.unpackNil();
                continue;
            }
            String string2 = fieldName;
            if (Intrinsics.areEqual((Object)string2, (Object)"key")) {
                key = unpacker.unpackString();
                continue;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"data")) {
                data = MsgpackSerializationKt.readObjectData(unpacker);
                continue;
            }
            unpacker.skipValue();
        }
        return new ObjectsMapOp(key, data);
    }

    private static final void writeMsgpack(ObjectsCounterOp $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 0;
        if ($this$writeMsgpack.getAmount() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if ($this$writeMsgpack.getAmount() != null) {
            packer.packString("amount");
            packer.packDouble($this$writeMsgpack.getAmount().doubleValue());
        }
    }

    private static final ObjectsCounterOp readObjectCounterOp(MessageUnpacker unpacker) {
        int fieldCount = unpacker.unpackMapHeader();
        Double amount = null;
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            String string = unpacker.unpackString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unpackString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.intern(), (String)"intern(...)");
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat == MessageFormat.NIL) {
                unpacker.unpackNil();
                continue;
            }
            if (Intrinsics.areEqual((Object)fieldName, (Object)"amount")) {
                amount = unpacker.unpackDouble();
                continue;
            }
            unpacker.skipValue();
        }
        return new ObjectsCounterOp(amount);
    }

    private static final void writeMsgpack(ObjectsMap $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 0;
        if ($this$writeMsgpack.getSemantics() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getEntries() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if ($this$writeMsgpack.getSemantics() != null) {
            packer.packString("semantics");
            packer.packInt($this$writeMsgpack.getSemantics().getCode());
        }
        if ($this$writeMsgpack.getEntries() != null) {
            packer.packString("entries");
            packer.packMapHeader($this$writeMsgpack.getEntries().size());
            for (Map.Entry<String, ObjectsMapEntry> entry : $this$writeMsgpack.getEntries().entrySet()) {
                String key = entry.getKey();
                ObjectsMapEntry value = entry.getValue();
                packer.packString(key);
                MsgpackSerializationKt.writeMsgpack(value, packer);
            }
        }
    }

    private static final ObjectsMap readObjectMap(MessageUnpacker unpacker) {
        int fieldCount = unpacker.unpackMapHeader();
        ObjectsMapSemantics semantics = null;
        Map entries2 = null;
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            String string = unpacker.unpackString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unpackString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.intern(), (String)"intern(...)");
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat == MessageFormat.NIL) {
                unpacker.unpackNil();
                continue;
            }
            String string2 = fieldName;
            if (Intrinsics.areEqual((Object)string2, (Object)"semantics")) {
                ObjectsMapSemantics objectsMapSemantics;
                Object v1;
                int semanticsCode;
                block9: {
                    semanticsCode = unpacker.unpackInt();
                    Iterable $this$firstOrNull$iv = (Iterable)ObjectsMapSemantics.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ObjectsMapSemantics it = (ObjectsMapSemantics)((Object)element$iv);
                        boolean bl = false;
                        if (!(it.getCode() == semanticsCode)) continue;
                        v1 = element$iv;
                        break block9;
                    }
                    v1 = null;
                }
                if ((objectsMapSemantics = (ObjectsMapSemantics)v1) == null) {
                    Object v3;
                    block10: {
                        Iterable $this$firstOrNull$iv = (Iterable)ObjectsMapSemantics.getEntries();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ObjectsMapSemantics it = (ObjectsMapSemantics)((Object)element$iv);
                            boolean bl = false;
                            if (!(it.getCode() == -1)) continue;
                            v3 = element$iv;
                            break block10;
                        }
                        v3 = null;
                    }
                    if ((objectsMapSemantics = (ObjectsMapSemantics)v3) == null) {
                        throw UtilsKt.objectError$default("Unknown MapSemantics code: " + semanticsCode + " and no UNKNOWN fallback found", null, 2, null);
                    }
                }
                semantics = objectsMapSemantics;
                continue;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"entries")) {
                int mapSize = unpacker.unpackMapHeader();
                Map tempMap = new LinkedHashMap();
                for (int j = 0; j < mapSize; ++j) {
                    String key = unpacker.unpackString();
                    ObjectsMapEntry value = MsgpackSerializationKt.readObjectMapEntry(unpacker);
                    tempMap.put(key, value);
                }
                entries2 = tempMap;
                continue;
            }
            unpacker.skipValue();
        }
        return new ObjectsMap(semantics, entries2);
    }

    private static final void writeMsgpack(ObjectsCounter $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 0;
        if ($this$writeMsgpack.getCount() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if ($this$writeMsgpack.getCount() != null) {
            packer.packString("count");
            packer.packDouble($this$writeMsgpack.getCount().doubleValue());
        }
    }

    private static final ObjectsCounter readObjectCounter(MessageUnpacker unpacker) {
        int fieldCount = unpacker.unpackMapHeader();
        Double count = null;
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            String string = unpacker.unpackString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unpackString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.intern(), (String)"intern(...)");
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat == MessageFormat.NIL) {
                unpacker.unpackNil();
                continue;
            }
            if (Intrinsics.areEqual((Object)fieldName, (Object)"count")) {
                count = unpacker.unpackDouble();
                continue;
            }
            unpacker.skipValue();
        }
        return new ObjectsCounter(count);
    }

    private static final void writeMsgpack(ObjectsMapEntry $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 0;
        if ($this$writeMsgpack.getTombstone() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getTimeserial() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getSerialTimestamp() != null) {
            ++fieldCount;
        }
        if ($this$writeMsgpack.getData() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if ($this$writeMsgpack.getTombstone() != null) {
            packer.packString("tombstone");
            packer.packBoolean($this$writeMsgpack.getTombstone().booleanValue());
        }
        if ($this$writeMsgpack.getTimeserial() != null) {
            packer.packString("timeserial");
            packer.packString($this$writeMsgpack.getTimeserial());
        }
        if ($this$writeMsgpack.getSerialTimestamp() != null) {
            packer.packString("serialTimestamp");
            packer.packLong($this$writeMsgpack.getSerialTimestamp().longValue());
        }
        if ($this$writeMsgpack.getData() != null) {
            packer.packString("data");
            MsgpackSerializationKt.writeMsgpack($this$writeMsgpack.getData(), packer);
        }
    }

    private static final ObjectsMapEntry readObjectMapEntry(MessageUnpacker unpacker) {
        int fieldCount = unpacker.unpackMapHeader();
        Boolean tombstone = null;
        String timeserial = null;
        Long serialTimestamp = null;
        ObjectData data = null;
        block12: for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            String string = unpacker.unpackString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unpackString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.intern(), (String)"intern(...)");
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat == MessageFormat.NIL) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "tombstone": {
                    tombstone = unpacker.unpackBoolean();
                    continue block12;
                }
                case "timeserial": {
                    timeserial = unpacker.unpackString();
                    continue block12;
                }
                case "serialTimestamp": {
                    serialTimestamp = unpacker.unpackLong();
                    continue block12;
                }
                case "data": {
                    data = MsgpackSerializationKt.readObjectData(unpacker);
                    continue block12;
                }
                default: {
                    unpacker.skipValue();
                }
            }
        }
        return new ObjectsMapEntry(tombstone, timeserial, serialTimestamp, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void writeMsgpack(ObjectData $this$writeMsgpack, MessagePacker packer) {
        int fieldCount = 0;
        if ($this$writeMsgpack.getObjectId() != null) {
            int n = fieldCount;
            fieldCount = n + 1;
        }
        ObjectValue objectValue = $this$writeMsgpack.getValue();
        if (objectValue != null) {
            ObjectValue it = objectValue;
            boolean bl = false;
            int n = fieldCount;
            fieldCount = n + 1;
        }
        packer.packMapHeader(fieldCount);
        if ($this$writeMsgpack.getObjectId() != null) {
            packer.packString("objectId");
            packer.packString($this$writeMsgpack.getObjectId());
        }
        ObjectValue objectValue2 = $this$writeMsgpack.getValue();
        if (objectValue2 == null) return;
        ObjectValue v = objectValue2;
        boolean bl = false;
        ObjectValue objectValue3 = v;
        if (objectValue3 instanceof ObjectValue.Boolean) {
            packer.packString("boolean");
            v2 = packer.packBoolean(((ObjectValue.Boolean)v).getValue().booleanValue());
            return;
        } else if (objectValue3 instanceof ObjectValue.String) {
            packer.packString("string");
            v2 = packer.packString(((ObjectValue.String)v).getValue());
            return;
        } else if (objectValue3 instanceof ObjectValue.Number) {
            packer.packString("number");
            v2 = packer.packDouble(((ObjectValue.Number)v).getValue().doubleValue());
            return;
        } else if (objectValue3 instanceof ObjectValue.Binary) {
            packer.packString("bytes");
            packer.packBinaryHeader(((ObjectValue.Binary)v).getValue().getData().length);
            v2 = packer.writePayload(((ObjectValue.Binary)v).getValue().getData());
            return;
        } else if (objectValue3 instanceof ObjectValue.JsonObject) {
            packer.packString("json");
            v2 = packer.packString(((ObjectValue.JsonObject)v).getValue().toString());
            return;
        } else {
            if (!(objectValue3 instanceof ObjectValue.JsonArray)) throw new NoWhenBranchMatchedException();
            packer.packString("json");
            v2 = packer.packString(((ObjectValue.JsonArray)v).getValue().toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final ObjectData readObjectData(MessageUnpacker unpacker) {
        fieldCount = unpacker.unpackMapHeader();
        objectId = null;
        value = null;
        block8: for (i = 0; i < fieldCount; ++i) {
            block21: {
                block20: {
                    block18: {
                        block19: {
                            v0 = unpacker.unpackString();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"unpackString(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)v0.intern(), (String)"intern(...)");
                            fieldFormat = unpacker.getNextFormat();
                            if (fieldFormat == MessageFormat.NIL) {
                                unpacker.unpackNil();
                                continue;
                            }
                            var7_7 = fieldName;
                            switch (var7_7.hashCode()) {
                                case -1034364087: {
                                    if (!var7_7.equals("number")) {
                                        ** break;
                                    }
                                    break block18;
                                }
                                case 64711720: {
                                    if (var7_7.equals("boolean")) break;
                                    ** break;
                                }
                                case -891985903: {
                                    if (!var7_7.equals("string")) {
                                        ** break;
                                    }
                                    break block19;
                                }
                                case 94224491: {
                                    if (!var7_7.equals("bytes")) {
                                        ** break;
                                    }
                                    break block20;
                                }
                                case 3271912: {
                                    if (!var7_7.equals("json")) {
                                        ** break;
                                    }
                                    break block21;
                                }
                                case 90495162: {
                                    if (!var7_7.equals("objectId")) ** break;
                                    objectId = unpacker.unpackString();
                                    continue block8;
                                }
                            }
                            value = new ObjectValue.Boolean(unpacker.unpackBoolean());
                            continue;
                        }
                        v1 = unpacker.unpackString();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"unpackString(...)");
                        value = new ObjectValue.String(v1);
                        continue;
                    }
                    value = new ObjectValue.Number(unpacker.unpackDouble());
                    continue;
                }
                size = unpacker.unpackBinaryHeader();
                bytes = new byte[size];
                unpacker.readPayload(bytes);
                value = new ObjectValue.Binary(new Binary(bytes));
                continue;
            }
            jsonString = unpacker.unpackString();
            parsed = JsonParser.parseString((String)jsonString);
            if (parsed.isJsonObject()) {
                v2 = parsed.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getAsJsonObject(...)");
                v3 = new ObjectValue.JsonObject(v2);
            } else if (parsed.isJsonArray()) {
                v4 = parsed.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getAsJsonArray(...)");
                v3 = new ObjectValue.JsonArray(v4);
            } else {
                throw UtilsKt.ablyException$default("Invalid JSON string for json field", ErrorCode.MapValueDataTypeUnsupported, HttpStatusCode.InternalServerError, null, 8, null);
            }
            value = v3;
            continue;
lbl70:
            // 7 sources

            unpacker.skipValue();
        }
        return new ObjectData(objectId, value);
    }
}

