/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.DefaultRealtimeObjects;
import io.ably.lib.objects.ObjectId;
import io.ably.lib.objects.type.BaseRealtimeObject;
import io.ably.lib.objects.type.ObjectType;
import io.ably.lib.objects.type.ObjectUpdate;
import io.ably.lib.objects.type.livecounter.DefaultLiveCounter;
import io.ably.lib.objects.type.livemap.DefaultLiveMap;
import io.ably.lib.util.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0013H\u0002J\b\u0010#\u001a\u00020\u000eH\u0002J\u0006\u0010$\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/ably/lib/objects/ObjectsPool;", "", "realtimeObjects", "Lio/ably/lib/objects/DefaultRealtimeObjects;", "<init>", "(Lio/ably/lib/objects/DefaultRealtimeObjects;)V", "tag", "", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/ably/lib/objects/type/BaseRealtimeObject;", "gcScope", "Lkotlinx/coroutines/CoroutineScope;", "gcJob", "Lkotlinx/coroutines/Job;", "get", "objectId", "get$liveobjects", "set", "", "realtimeObject", "set$liveobjects", "resetToInitialPool", "emitUpdateEvents", "", "resetToInitialPool$liveobjects", "deleteExtraObjectIds", "objectIds", "", "deleteExtraObjectIds$liveobjects", "clearObjectsData", "clearObjectsData$liveobjects", "createZeroValueObjectIfNotExists", "createZeroValueObjectIfNotExists$liveobjects", "onGCInterval", "startGCJob", "dispose", "liveobjects"})
public final class ObjectsPool {
    @NotNull
    private final DefaultRealtimeObjects realtimeObjects;
    @NotNull
    private final String tag;
    @NotNull
    private final ConcurrentHashMap<String, BaseRealtimeObject> pool;
    @NotNull
    private final CoroutineScope gcScope;
    @NotNull
    private Job gcJob;

    public ObjectsPool(@NotNull DefaultRealtimeObjects realtimeObjects) {
        Intrinsics.checkNotNullParameter((Object)realtimeObjects, (String)"realtimeObjects");
        this.realtimeObjects = realtimeObjects;
        this.tag = "ObjectsPool";
        this.pool = new ConcurrentHashMap();
        this.gcScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        ((Map)this.pool).put("root", DefaultLiveMap.Companion.zeroValue$liveobjects("root", this.realtimeObjects));
        this.gcJob = this.startGCJob();
    }

    @Nullable
    public final BaseRealtimeObject get$liveobjects(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return this.pool.get(objectId);
    }

    public final void set$liveobjects(@NotNull String objectId, @NotNull BaseRealtimeObject realtimeObject) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Intrinsics.checkNotNullParameter((Object)realtimeObject, (String)"realtimeObject");
        ((Map)this.pool).put(objectId, realtimeObject);
    }

    public final void resetToInitialPool$liveobjects(boolean emitUpdateEvents) {
        this.pool.entrySet().removeIf(arg_0 -> ObjectsPool.resetToInitialPool$lambda$1(ObjectsPool::resetToInitialPool$lambda$0, arg_0));
        this.clearObjectsData$liveobjects(emitUpdateEvents);
    }

    public final void deleteExtraObjectIds$liveobjects(@NotNull Set<String> objectIds) {
        Intrinsics.checkNotNullParameter(objectIds, (String)"objectIds");
        this.pool.entrySet().removeIf(arg_0 -> ObjectsPool.deleteExtraObjectIds$lambda$3(arg_0 -> ObjectsPool.deleteExtraObjectIds$lambda$2(objectIds, arg_0), arg_0));
    }

    public final void clearObjectsData$liveobjects(boolean emitUpdateEvents) {
        Iterator<BaseRealtimeObject> iterator = this.pool.values().iterator();
        while (iterator.hasNext()) {
            BaseRealtimeObject obj;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            ObjectUpdate update = obj.clearData();
            if (!emitUpdateEvents) continue;
            obj.notifyUpdated(update);
        }
    }

    @NotNull
    public final BaseRealtimeObject createZeroValueObjectIfNotExists$liveobjects(@NotNull String objectId) {
        BaseRealtimeObject baseRealtimeObject;
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        BaseRealtimeObject existingObject = this.get$liveobjects(objectId);
        if (existingObject != null) {
            return existingObject;
        }
        ObjectId parsedObjectId = ObjectId.Companion.fromString$liveobjects(objectId);
        BaseRealtimeObject $this$createZeroValueObjectIfNotExists_u24lambda_u244 = baseRealtimeObject = (switch (WhenMappings.$EnumSwitchMapping$0[parsedObjectId.getType$liveobjects().ordinal()]) {
            case 1 -> DefaultLiveMap.Companion.zeroValue$liveobjects(objectId, this.realtimeObjects);
            case 2 -> DefaultLiveCounter.Companion.zeroValue$liveobjects(objectId, this.realtimeObjects);
            default -> throw new NoWhenBranchMatchedException();
        });
        boolean bl = false;
        this.set$liveobjects(objectId, $this$createZeroValueObjectIfNotExists_u24lambda_u244);
        return baseRealtimeObject;
    }

    private final void onGCInterval() {
        this.pool.entrySet().removeIf(arg_0 -> ObjectsPool.onGCInterval$lambda$6(ObjectsPool::onGCInterval$lambda$5, arg_0));
    }

    private final Job startGCJob() {
        return BuildersKt.launch$default((CoroutineScope)this.gcScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ObjectsPool this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            try {
                                ObjectsPool.access$onGCInterval(this.this$0);
                            }
                            catch (Exception e) {
                                Log.e((String)ObjectsPool.access$getTag$p(this.this$0), (String)"Error during garbage collection", (Throwable)e);
                            }
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)300000L, (Continuation)((Continuation)this));
                            if (v0 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void dispose() {
        Job.DefaultImpls.cancel$default((Job)this.gcJob, null, (int)1, null);
        CoroutineScopeKt.cancel$default((CoroutineScope)this.gcScope, null, (int)1, null);
        this.pool.clear();
    }

    private static final boolean resetToInitialPool$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Object k = entry.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
        String key = (String)k;
        return !Intrinsics.areEqual((Object)key, (Object)"root");
    }

    private static final boolean resetToInitialPool$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean deleteExtraObjectIds$lambda$2(Set $objectIds, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Object k = entry.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
        String key = (String)k;
        return !$objectIds.contains(key) && !Intrinsics.areEqual((Object)key, (Object)"root");
    }

    private static final boolean deleteExtraObjectIds$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onGCInterval$lambda$5(Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Object v = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
        BaseRealtimeObject obj = (BaseRealtimeObject)v;
        if (obj.isEligibleForGc$liveobjects()) {
            bl = true;
        } else {
            obj.onGCInterval();
            bl = false;
        }
        return bl;
    }

    private static final boolean onGCInterval$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$onGCInterval(ObjectsPool $this) {
        $this.onGCInterval();
    }

    public static final /* synthetic */ String access$getTag$p(ObjectsPool $this) {
        return $this.tag;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObjectType.values().length];
            try {
                nArray[ObjectType.Map.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectType.Counter.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

