/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.DefaultRealtimeObjects;
import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectOperationAction;
import io.ably.lib.objects.ObjectState;
import io.ably.lib.objects.ObjectsState;
import io.ably.lib.objects.ObjectsStateCoordinator;
import io.ably.lib.objects.ObjectsSyncTracker;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.type.BaseRealtimeObject;
import io.ably.lib.objects.type.ObjectUpdate;
import io.ably.lib.objects.type.livecounter.DefaultLiveCounter;
import io.ably.lib.objects.type.livemap.DefaultLiveMap;
import io.ably.lib.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0000\u00a2\u0006\u0002\b\u0012J%\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0015J\u0017\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u000fH\u0002J\u0016\u0010\"\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J\u0016\u0010#\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001bH\u0002J\r\u0010,\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/ably/lib/objects/ObjectsManager;", "Lio/ably/lib/objects/ObjectsStateCoordinator;", "realtimeObjects", "Lio/ably/lib/objects/DefaultRealtimeObjects;", "<init>", "(Lio/ably/lib/objects/DefaultRealtimeObjects;)V", "tag", "", "syncObjectsDataPool", "", "Lio/ably/lib/objects/ObjectMessage;", "currentSyncId", "bufferedObjectOperations", "", "handleObjectMessages", "", "objectMessages", "", "handleObjectMessages$liveobjects", "handleObjectSyncMessages", "syncChannelSerial", "handleObjectSyncMessages$liveobjects", "startNewSync", "syncId", "startNewSync$liveobjects", "endSync", "deferStateEvent", "", "endSync$liveobjects", "clearSyncObjectsDataPool", "clearSyncObjectsDataPool$liveobjects", "clearBufferedObjectOperations", "clearBufferedObjectOperations$liveobjects", "applySync", "applyObjectMessages", "applyObjectSyncMessages", "createObjectFromState", "Lio/ably/lib/objects/type/BaseRealtimeObject;", "objectState", "Lio/ably/lib/objects/ObjectState;", "stateChange", "newState", "Lio/ably/lib/objects/ObjectsState;", "deferEvent", "dispose", "dispose$liveobjects", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nObjectsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectsManager.kt\nio/ably/lib/objects/ObjectsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1863#2,2:249\n*S KotlinDebug\n*F\n+ 1 ObjectsManager.kt\nio/ably/lib/objects/ObjectsManager\n*L\n155#1:249,2\n*E\n"})
public final class ObjectsManager
extends ObjectsStateCoordinator {
    @NotNull
    private final DefaultRealtimeObjects realtimeObjects;
    @NotNull
    private final String tag;
    @NotNull
    private final Map<String, ObjectMessage> syncObjectsDataPool;
    @Nullable
    private String currentSyncId;
    @NotNull
    private final List<ObjectMessage> bufferedObjectOperations;

    public ObjectsManager(@NotNull DefaultRealtimeObjects realtimeObjects) {
        Intrinsics.checkNotNullParameter((Object)realtimeObjects, (String)"realtimeObjects");
        this.realtimeObjects = realtimeObjects;
        this.tag = "ObjectsManager";
        this.syncObjectsDataPool = new LinkedHashMap();
        this.bufferedObjectOperations = new ArrayList();
    }

    public final void handleObjectMessages$liveobjects(@NotNull List<ObjectMessage> objectMessages) {
        Intrinsics.checkNotNullParameter(objectMessages, (String)"objectMessages");
        if (this.realtimeObjects.getState$liveobjects() != ObjectsState.Synced) {
            Log.v((String)this.tag, (String)("Buffering " + objectMessages.size() + " object messages, state: " + this.realtimeObjects.getState$liveobjects()));
            this.bufferedObjectOperations.addAll((Collection<ObjectMessage>)objectMessages);
            return;
        }
        this.applyObjectMessages(objectMessages);
    }

    public final void handleObjectSyncMessages$liveobjects(@NotNull List<ObjectMessage> objectMessages, @Nullable String syncChannelSerial) {
        Intrinsics.checkNotNullParameter(objectMessages, (String)"objectMessages");
        ObjectsSyncTracker syncTracker = new ObjectsSyncTracker(syncChannelSerial);
        boolean isNewSync = syncTracker.hasSyncStarted$liveobjects(this.currentSyncId);
        if (isNewSync) {
            this.startNewSync$liveobjects(syncTracker.getSyncId$liveobjects());
        }
        this.applyObjectSyncMessages(objectMessages);
        if (syncTracker.hasSyncEnded$liveobjects()) {
            this.endSync$liveobjects(isNewSync);
        }
    }

    public final void startNewSync$liveobjects(@Nullable String syncId) {
        Log.v((String)this.tag, (String)("Starting new sync sequence: syncId=" + syncId));
        this.bufferedObjectOperations.clear();
        this.syncObjectsDataPool.clear();
        this.currentSyncId = syncId;
        this.stateChange(ObjectsState.Syncing, false);
    }

    public final void endSync$liveobjects(boolean deferStateEvent) {
        Log.v((String)this.tag, (String)"Ending sync sequence");
        this.applySync();
        this.applyObjectMessages(this.bufferedObjectOperations);
        this.bufferedObjectOperations.clear();
        this.syncObjectsDataPool.clear();
        this.currentSyncId = null;
        this.stateChange(ObjectsState.Synced, deferStateEvent);
    }

    public final void clearSyncObjectsDataPool$liveobjects() {
        this.syncObjectsDataPool.clear();
    }

    public final void clearBufferedObjectOperations$liveobjects() {
        this.bufferedObjectOperations.clear();
    }

    private final void applySync() {
        if (this.syncObjectsDataPool.isEmpty()) {
            return;
        }
        Set receivedObjectIds = new LinkedHashSet();
        List existingObjectUpdates = new ArrayList();
        for (Map.Entry<String, ObjectMessage> entry : this.syncObjectsDataPool.entrySet()) {
            ObjectState objectState;
            String objectId = entry.getKey();
            ObjectMessage objectMessage = entry.getValue();
            Intrinsics.checkNotNull((Object)objectMessage.getObjectState(), (String)"null cannot be cast to non-null type io.ably.lib.objects.ObjectState");
            receivedObjectIds.add(objectId);
            BaseRealtimeObject existingObject = this.realtimeObjects.getObjectsPool$liveobjects().get$liveobjects(objectId);
            if (existingObject != null) {
                ObjectUpdate update = existingObject.applyObjectSync$liveobjects(objectMessage);
                existingObjectUpdates.add(new Pair((Object)existingObject, (Object)update));
                continue;
            }
            BaseRealtimeObject newObject = this.createObjectFromState(objectState);
            newObject.applyObjectSync$liveobjects(objectMessage);
            this.realtimeObjects.getObjectsPool$liveobjects().set$liveobjects(objectId, newObject);
        }
        this.realtimeObjects.getObjectsPool$liveobjects().deleteExtraObjectIds$liveobjects(receivedObjectIds);
        Iterable $this$forEach$iv = existingObjectUpdates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            BaseRealtimeObject obj = (BaseRealtimeObject)pair.component1();
            ObjectUpdate update = (ObjectUpdate)pair.component2();
            obj.notifyUpdated(update);
        }
    }

    private final void applyObjectMessages(List<ObjectMessage> objectMessages) {
        for (ObjectMessage objectMessage : objectMessages) {
            if (objectMessage.getOperation() == null) {
                Log.w((String)this.tag, (String)("Object message received without operation field, skipping message: " + objectMessage.getId()));
                continue;
            }
            ObjectOperation objectOperation = objectMessage.getOperation();
            if (objectOperation.getAction() == ObjectOperationAction.Unknown) {
                Log.w((String)this.tag, (String)("Object operation action is unknown, skipping message: " + objectMessage.getId()));
                continue;
            }
            BaseRealtimeObject obj = this.realtimeObjects.getObjectsPool$liveobjects().createZeroValueObjectIfNotExists$liveobjects(objectOperation.getObjectId());
            obj.applyObject$liveobjects(objectMessage);
        }
    }

    private final void applyObjectSyncMessages(List<ObjectMessage> objectMessages) {
        for (ObjectMessage objectMessage : objectMessages) {
            if (objectMessage.getObjectState() == null) {
                Log.w((String)this.tag, (String)("Object message received during OBJECT_SYNC without object field, skipping message: " + objectMessage.getId()));
                continue;
            }
            ObjectState objectState = objectMessage.getObjectState();
            if (objectState.getCounter() != null || objectState.getMap() != null) {
                this.syncObjectsDataPool.put(objectState.getObjectId(), objectMessage);
                continue;
            }
            Log.w((String)this.tag, (String)("Object state received without counter or map data, skipping message: " + objectMessage.getId()));
        }
    }

    private final BaseRealtimeObject createObjectFromState(ObjectState objectState) {
        BaseRealtimeObject baseRealtimeObject;
        if (objectState.getCounter() != null) {
            baseRealtimeObject = DefaultLiveCounter.Companion.zeroValue$liveobjects(objectState.getObjectId(), this.realtimeObjects);
        } else if (objectState.getMap() != null) {
            baseRealtimeObject = DefaultLiveMap.Companion.zeroValue$liveobjects(objectState.getObjectId(), this.realtimeObjects);
        } else {
            throw UtilsKt.clientError("Object state must contain either counter or map data");
        }
        return baseRealtimeObject;
    }

    private final void stateChange(ObjectsState newState, boolean deferEvent) {
        if (this.realtimeObjects.getState$liveobjects() == newState) {
            return;
        }
        Log.v((String)this.tag, (String)("Objects state changed to: " + newState + " from " + this.realtimeObjects.getState$liveobjects()));
        this.realtimeObjects.setState$liveobjects(newState);
        this.objectsStateChanged(newState);
    }

    public final void dispose$liveobjects() {
        this.syncObjectsDataPool.clear();
        this.bufferedObjectOperations.clear();
        this.disposeObjectsStateListeners();
    }
}

