/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.type.ObjectType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/ably/lib/objects/ObjectId;", "", "type", "Lio/ably/lib/objects/type/ObjectType;", "hash", "", "timestampMs", "", "<init>", "(Lio/ably/lib/objects/type/ObjectType;Ljava/lang/String;J)V", "getType$liveobjects", "()Lio/ably/lib/objects/type/ObjectType;", "toString", "Companion", "liveobjects"})
public final class ObjectId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectType type;
    @NotNull
    private final String hash;
    private final long timestampMs;

    private ObjectId(ObjectType type, String hash, long timestampMs) {
        this.type = type;
        this.hash = hash;
        this.timestampMs = timestampMs;
    }

    @NotNull
    public final ObjectType getType$liveobjects() {
        return this.type;
    }

    @NotNull
    public String toString() {
        return this.type.getValue() + ":" + this.hash + "@" + this.timestampMs;
    }

    public /* synthetic */ ObjectId(ObjectType type, String hash, long timestampMs, DefaultConstructorMarker $constructor_marker) {
        this(type, hash, timestampMs);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0015\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lio/ably/lib/objects/ObjectId$Companion;", "", "<init>", "()V", "fromInitialValue", "Lio/ably/lib/objects/ObjectId;", "objectType", "Lio/ably/lib/objects/type/ObjectType;", "initialValue", "", "nonce", "msTimeStamp", "", "fromInitialValue$liveobjects", "fromString", "objectId", "fromString$liveobjects", "liveobjects"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectId fromInitialValue$liveobjects(@NotNull ObjectType objectType, @NotNull String initialValue, @NotNull String nonce, long msTimeStamp) {
            Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
            Intrinsics.checkNotNullParameter((Object)initialValue, (String)"initialValue");
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            String string = initialValue + ":" + nonce;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] valueForHash = byArray;
            byte[] hashBytes = MessageDigest.getInstance("SHA-256").digest(valueForHash);
            String urlSafeHash = Base64.getUrlEncoder().withoutPadding().encodeToString(hashBytes);
            Intrinsics.checkNotNull((Object)urlSafeHash);
            return new ObjectId(objectType, urlSafeHash, msTimeStamp, null);
        }

        @NotNull
        public final ObjectId fromString$liveobjects(@NotNull String objectId) {
            long l;
            ObjectType objectType;
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            if (((CharSequence)objectId).length() == 0) {
                throw UtilsKt.objectError$default("Invalid object id: " + objectId, null, 2, null);
            }
            char[] cArray = new char[]{':'};
            List parts = StringsKt.split$default((CharSequence)objectId, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                throw UtilsKt.objectError$default("Invalid object id: " + objectId, null, 2, null);
            }
            String typeStr = (String)parts.get(0);
            String rest = (String)parts.get(1);
            String string = typeStr;
            if (Intrinsics.areEqual((Object)string, (Object)"map")) {
                objectType = ObjectType.Map;
            } else if (Intrinsics.areEqual((Object)string, (Object)"counter")) {
                objectType = ObjectType.Counter;
            } else {
                throw UtilsKt.objectError$default("Invalid object type in object id: " + objectId, null, 2, null);
            }
            ObjectType type = objectType;
            char[] cArray2 = new char[]{'@'};
            List hashAndTimestamp = StringsKt.split$default((CharSequence)rest, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            if (hashAndTimestamp.size() != 2) {
                throw UtilsKt.objectError$default("Invalid object id: " + objectId, null, 2, null);
            }
            String hash = (String)hashAndTimestamp.get(0);
            if (((CharSequence)hash).length() == 0) {
                throw UtilsKt.objectError$default("Invalid object id: " + objectId, null, 2, null);
            }
            String msTimestampStr = (String)hashAndTimestamp.get(1);
            try {
                l = Long.parseLong(msTimestampStr);
            }
            catch (NumberFormatException e) {
                throw UtilsKt.objectError("Invalid object id: " + objectId, e);
            }
            long msTimestamp = l;
            return new ObjectId(type, hash, msTimestamp, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

