/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.Binary;
import io.ably.lib.objects.ErrorCode;
import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectMessageKt;
import io.ably.lib.objects.ObjectsAdapter;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.realtime.ChannelBase;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.ChannelStateListener;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelMode;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.ProtocolMessage;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0080@\u00a2\u0006\u0002\u0010\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0080@\u00a2\u0006\u0002\u0010\t\u001a!\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\u0010\r\u001a\u001f\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u001c\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0080@\u00a2\u0006\u0002\u0010\t\u001a\u0014\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\fH\u0002\u001a'\u0010\u001a\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000bH\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\f\u0010\u001e\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u001f\u001a\u00020 *\u00020!H\u0000\u00a8\u0006\""}, d2={"sendAsync", "", "Lio/ably/lib/objects/ObjectsAdapter;", "message", "Lio/ably/lib/types/ProtocolMessage;", "(Lio/ably/lib/objects/ObjectsAdapter;Lio/ably/lib/types/ProtocolMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attachAsync", "channelName", "", "(Lio/ably/lib/objects/ObjectsAdapter;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getChannelModes", "", "Lio/ably/lib/types/ChannelMode;", "(Lio/ably/lib/objects/ObjectsAdapter;Ljava/lang/String;)[Lio/ably/lib/types/ChannelMode;", "ensureMessageSizeWithinLimit", "objectMessages", "Lio/ably/lib/objects/ObjectMessage;", "(Lio/ably/lib/objects/ObjectsAdapter;[Lio/ably/lib/objects/ObjectMessage;)V", "setChannelSerial", "protocolMessage", "ensureAttached", "throwIfInvalidAccessApiConfiguration", "throwIfInvalidWriteApiConfiguration", "throwIfUnpublishableState", "throwIfMissingChannelMode", "channelMode", "throwIfInChannelState", "channelStates", "Lio/ably/lib/realtime/ChannelState;", "(Lio/ably/lib/objects/ObjectsAdapter;Ljava/lang/String;[Lio/ably/lib/realtime/ChannelState;)V", "throwIfEchoMessagesDisabled", "size", "", "Lio/ably/lib/objects/Binary;", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helpers.kt\nio/ably/lib/objects/HelpersKt\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n351#2,11:186\n351#2,11:197\n1#3:208\n*S KotlinDebug\n*F\n+ 1 Helpers.kt\nio/ably/lib/objects/HelpersKt\n*L\n16#1:186,11\n32#1:197,11\n*E\n"})
public final class HelpersKt {
    @Nullable
    public static final Object sendAsync(@NotNull ObjectsAdapter $this$sendAsync, @NotNull ProtocolMessage message, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        try {
            $this$sendAsync.getConnectionManager().send(message, $this$sendAsync.getClientOptions().queueMessages, new CompletionListener((CancellableContinuation<? super Unit>)continuation){
                final /* synthetic */ CancellableContinuation<Unit> $continuation;
                {
                    this.$continuation = $continuation;
                }

                public void onSuccess() {
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                }

                public void onError(ErrorInfo reason) {
                    Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)UtilsKt.ablyException$default(reason, null, 2, null)))));
                }
            });
        }
        catch (Exception e) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object attachAsync(@NotNull ObjectsAdapter $this$attachAsync, @NotNull String channelName, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        try {
            $this$attachAsync.getChannel(channelName).attach(new CompletionListener((CancellableContinuation<? super Unit>)continuation){
                final /* synthetic */ CancellableContinuation<Unit> $continuation;
                {
                    this.$continuation = $continuation;
                }

                public void onSuccess() {
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                }

                public void onError(ErrorInfo reason) {
                    Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)UtilsKt.ablyException$default(reason, null, 2, null)))));
                }
            });
        }
        catch (Exception e) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final ChannelMode[] getChannelModes(@NotNull ObjectsAdapter $this$getChannelModes, @NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)$this$getChannelModes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        ChannelBase channelBase = $this$getChannelModes.getChannel(channelName);
        Intrinsics.checkNotNullExpressionValue((Object)channelBase, (String)"getChannel(...)");
        ChannelBase channel = channelBase;
        ChannelMode[] channelModeArray = channel.getModes();
        if (channelModeArray != null) {
            ChannelMode[] modes = channelModeArray;
            boolean bl = false;
            if (!(modes.length == 0)) {
                return modes;
            }
        }
        ChannelOptions channelOptions = channel.getOptions();
        if (channelOptions != null) {
            ChannelOptions options = channelOptions;
            boolean bl = false;
            if (options.hasModes()) {
                return options.modes;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void ensureMessageSizeWithinLimit(@NotNull ObjectsAdapter $this$ensureMessageSizeWithinLimit, @NotNull ObjectMessage[] objectMessages) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureMessageSizeWithinLimit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectMessages, (String)"objectMessages");
        int maximumAllowedSize = $this$ensureMessageSizeWithinLimit.getConnectionManager().maxMessageSize;
        ObjectMessage[] objectMessageArray = objectMessages;
        int n = 0;
        int n2 = objectMessageArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            ObjectMessage objectMessage;
            ObjectMessage objectMessage2 = objectMessage = objectMessageArray[i];
            int n3 = n;
            boolean bl = false;
            int n4 = ObjectMessageKt.size((ObjectMessage)it);
            n = n3 + n4;
        }
        int objectsTotalMessageSize = n;
        if (objectsTotalMessageSize > maximumAllowedSize) {
            throw UtilsKt.ablyException$default("ObjectMessages size " + objectsTotalMessageSize + " exceeds maximum allowed size of " + maximumAllowedSize + " bytes", ErrorCode.MaxMessageSizeExceeded, null, null, 12, null);
        }
    }

    public static final void setChannelSerial(@NotNull ObjectsAdapter $this$setChannelSerial, @NotNull String channelName, @NotNull ProtocolMessage protocolMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$setChannelSerial, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        Intrinsics.checkNotNullParameter((Object)protocolMessage, (String)"protocolMessage");
        if (protocolMessage.action != ProtocolMessage.Action.object) {
            return;
        }
        String channelSerial = protocolMessage.channelSerial;
        CharSequence charSequence = channelSerial;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        $this$setChannelSerial.getChannel((String)channelName).properties.channelSerial = channelSerial;
    }

    @Nullable
    public static final Object ensureAttached(@NotNull ObjectsAdapter $this$ensureAttached, @NotNull String channelName, @NotNull Continuation<? super Unit> $completion) {
        ChannelState currentChannelStatus;
        ChannelBase channelBase = $this$ensureAttached.getChannel(channelName);
        Intrinsics.checkNotNullExpressionValue((Object)channelBase, (String)"getChannel(...)");
        ChannelBase channel = channelBase;
        ChannelState channelState = currentChannelStatus = channel.state;
        switch (channelState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[channelState.ordinal()]) {
            case 2: {
                Object object = HelpersKt.attachAsync($this$ensureAttached, channelName, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 1: {
                return Unit.INSTANCE;
            }
            case 3: {
                CompletableDeferred attachDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                $this$ensureAttached.getChannel(channelName).once(arg_0 -> HelpersKt.ensureAttached$lambda$5(attachDeferred, channelName, arg_0));
                if (channel.state == ChannelState.attached) {
                    attachDeferred.complete((Object)Unit.INSTANCE);
                }
                Object object = attachDeferred.await($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        throw UtilsKt.ablyException$default("Channel " + channelName + " is in invalid state: " + currentChannelStatus, ErrorCode.ChannelStateError, null, null, 12, null);
    }

    public static final void throwIfInvalidAccessApiConfiguration(@NotNull ObjectsAdapter $this$throwIfInvalidAccessApiConfiguration, @NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfInvalidAccessApiConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        ChannelState[] channelStateArray = new ChannelState[]{ChannelState.detached, ChannelState.failed};
        HelpersKt.throwIfInChannelState($this$throwIfInvalidAccessApiConfiguration, channelName, channelStateArray);
        HelpersKt.throwIfMissingChannelMode($this$throwIfInvalidAccessApiConfiguration, channelName, ChannelMode.object_subscribe);
    }

    public static final void throwIfInvalidWriteApiConfiguration(@NotNull ObjectsAdapter $this$throwIfInvalidWriteApiConfiguration, @NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfInvalidWriteApiConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        HelpersKt.throwIfEchoMessagesDisabled($this$throwIfInvalidWriteApiConfiguration);
        ChannelState[] channelStateArray = new ChannelState[]{ChannelState.detached, ChannelState.failed, ChannelState.suspended};
        HelpersKt.throwIfInChannelState($this$throwIfInvalidWriteApiConfiguration, channelName, channelStateArray);
        HelpersKt.throwIfMissingChannelMode($this$throwIfInvalidWriteApiConfiguration, channelName, ChannelMode.object_publish);
    }

    public static final void throwIfUnpublishableState(@NotNull ObjectsAdapter $this$throwIfUnpublishableState, @NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfUnpublishableState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        if (!$this$throwIfUnpublishableState.getConnectionManager().isActive()) {
            ErrorInfo errorInfo = $this$throwIfUnpublishableState.getConnectionManager().getStateErrorInfo();
            Intrinsics.checkNotNullExpressionValue((Object)errorInfo, (String)"getStateErrorInfo(...)");
            throw UtilsKt.ablyException$default(errorInfo, null, 2, null);
        }
        ChannelState[] channelStateArray = new ChannelState[]{ChannelState.failed, ChannelState.suspended};
        HelpersKt.throwIfInChannelState($this$throwIfUnpublishableState, channelName, channelStateArray);
    }

    private static final void throwIfMissingChannelMode(ObjectsAdapter $this$throwIfMissingChannelMode, String channelName, ChannelMode channelMode) {
        Object[] channelModes = HelpersKt.getChannelModes($this$throwIfMissingChannelMode, channelName);
        if (channelModes == null || !ArraysKt.contains((Object[])channelModes, (Object)channelMode)) {
            throw UtilsKt.ablyException$default("\"" + channelMode.name() + "\" channel mode must be set for this operation", ErrorCode.ChannelModeRequired, null, null, 12, null);
        }
    }

    private static final void throwIfInChannelState(ObjectsAdapter $this$throwIfInChannelState, String channelName, ChannelState[] channelStates) {
        ChannelState currentState = $this$throwIfInChannelState.getChannel((String)channelName).state;
        if (currentState == null || ArraysKt.contains((Object[])channelStates, (Object)currentState)) {
            throw UtilsKt.ablyException$default("Channel is in invalid state: " + currentState, ErrorCode.ChannelStateError, null, null, 12, null);
        }
    }

    public static final void throwIfEchoMessagesDisabled(@NotNull ObjectsAdapter $this$throwIfEchoMessagesDisabled) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfEchoMessagesDisabled, (String)"<this>");
        if (!$this$throwIfEchoMessagesDisabled.getClientOptions().echoMessages) {
            throw UtilsKt.clientError("\"echoMessages\" client option must be enabled for this operation");
        }
    }

    public static final int size(@NotNull Binary $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return $this$size.getData().length;
    }

    private static final void ensureAttached$lambda$5(CompletableDeferred $attachDeferred, String $channelName, ChannelStateListener.ChannelStateChange it) {
        ChannelState channelState = it.current;
        if ((channelState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[channelState.ordinal()]) == 1) {
            v1 = $attachDeferred.complete((Object)Unit.INSTANCE);
        } else {
            AblyException exception = UtilsKt.ablyException$default("Channel " + $channelName + " is in invalid state: " + it.current + ", error: " + it.reason, ErrorCode.ChannelStateError, null, null, 12, null);
            v1 = $attachDeferred.completeExceptionally((Throwable)exception);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChannelState.values().length];
            try {
                nArray[ChannelState.attached.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelState.initialized.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelState.attaching.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

