/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.CounterCreatePayload;
import io.ably.lib.objects.DefaultRealtimeObjects;
import io.ably.lib.objects.HelpersKt;
import io.ably.lib.objects.MapCreatePayload;
import io.ably.lib.objects.ObjectId;
import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectOperationAction;
import io.ably.lib.objects.ObjectsAdapter;
import io.ably.lib.objects.ObjectsAsyncScope;
import io.ably.lib.objects.ObjectsCallback;
import io.ably.lib.objects.ObjectsManager;
import io.ably.lib.objects.ObjectsPool;
import io.ably.lib.objects.ObjectsState;
import io.ably.lib.objects.ObjectsSubscription;
import io.ably.lib.objects.RealtimeObjects;
import io.ably.lib.objects.ServerTime;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.serialization.JsonSerializationKt;
import io.ably.lib.objects.state.ObjectsStateChange;
import io.ably.lib.objects.state.ObjectsStateEvent;
import io.ably.lib.objects.type.BaseRealtimeObject;
import io.ably.lib.objects.type.ObjectType;
import io.ably.lib.objects.type.counter.LiveCounter;
import io.ably.lib.objects.type.livecounter.DefaultLiveCounter;
import io.ably.lib.objects.type.livemap.DefaultLiveMap;
import io.ably.lib.objects.type.map.LiveMap;
import io.ably.lib.objects.type.map.LiveMapValue;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u00020%2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020)0(H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020%01H\u0016J\u0016\u00102\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020%01H\u0016J*\u00102\u001a\u00020/2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020)0(2\f\u00100\u001a\b\u0012\u0004\u0012\u00020%01H\u0016J\u0016\u00103\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020+01H\u0016J\u001e\u00103\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\f\u00100\u001a\b\u0012\u0004\u0012\u00020+01H\u0016J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020/2\u0006\u00108\u001a\u000209H\u0016J\b\u0010;\u001a\u00020/H\u0016J\u000e\u0010.\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010<J\"\u00102\u001a\u00020%2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020)0(H\u0082@\u00a2\u0006\u0002\u0010=J\u0016\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0082@\u00a2\u0006\u0002\u0010>J*\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030@2\u0006\u0010A\u001a\u00020B2\u0006\u0010,\u001a\u00020\u0003H\u0082@\u00a2\u0006\u0002\u0010CJ\u001e\u0010D\u001a\u00020/2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FH\u0080@\u00a2\u0006\u0004\bH\u0010IJ\u0015\u0010J\u001a\u00020/2\u0006\u0010K\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u00020\u001fH\u0002J\u001d\u0010N\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0000\u00a2\u0006\u0002\bRJ\u000e\u0010S\u001a\u00020/2\u0006\u0010T\u001a\u00020UR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006V"}, d2={"Lio/ably/lib/objects/DefaultRealtimeObjects;", "Lio/ably/lib/objects/RealtimeObjects;", "channelName", "", "adapter", "Lio/ably/lib/objects/ObjectsAdapter;", "<init>", "(Ljava/lang/String;Lio/ably/lib/objects/ObjectsAdapter;)V", "getChannelName$liveobjects", "()Ljava/lang/String;", "getAdapter$liveobjects", "()Lio/ably/lib/objects/ObjectsAdapter;", "tag", "objectsPool", "Lio/ably/lib/objects/ObjectsPool;", "getObjectsPool$liveobjects", "()Lio/ably/lib/objects/ObjectsPool;", "state", "Lio/ably/lib/objects/ObjectsState;", "getState$liveobjects", "()Lio/ably/lib/objects/ObjectsState;", "setState$liveobjects", "(Lio/ably/lib/objects/ObjectsState;)V", "objectsManager", "Lio/ably/lib/objects/ObjectsManager;", "sequentialScope", "Lkotlinx/coroutines/CoroutineScope;", "objectsEventBus", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/ably/lib/types/ProtocolMessage;", "incomingObjectsHandler", "Lkotlinx/coroutines/Job;", "asyncScope", "Lio/ably/lib/objects/ObjectsAsyncScope;", "getAsyncScope$liveobjects", "()Lio/ably/lib/objects/ObjectsAsyncScope;", "getRoot", "Lio/ably/lib/objects/type/map/LiveMap;", "createMap", "entries", "", "Lio/ably/lib/objects/type/map/LiveMapValue;", "createCounter", "Lio/ably/lib/objects/type/counter/LiveCounter;", "initialValue", "", "getRootAsync", "", "callback", "Lio/ably/lib/objects/ObjectsCallback;", "createMapAsync", "createCounterAsync", "on", "Lio/ably/lib/objects/ObjectsSubscription;", "event", "Lio/ably/lib/objects/state/ObjectsStateEvent;", "listener", "Lio/ably/lib/objects/state/ObjectsStateChange$Listener;", "off", "offAll", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/Number;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getObjectIdStringWithNonce", "Lkotlin/Pair;", "objectType", "Lio/ably/lib/objects/type/ObjectType;", "(Lio/ably/lib/objects/type/ObjectType;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publish", "objectMessages", "", "Lio/ably/lib/objects/ObjectMessage;", "publish$liveobjects", "([Lio/ably/lib/objects/ObjectMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handle", "protocolMessage", "handle$liveobjects", "initializeHandlerForIncomingObjectMessages", "handleStateChange", "Lio/ably/lib/realtime/ChannelState;", "hasObjects", "", "handleStateChange$liveobjects", "dispose", "cause", "Lio/ably/lib/types/AblyException;", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nDefaultRealtimeObjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultRealtimeObjects.kt\nio/ably/lib/objects/DefaultRealtimeObjects\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1755#2,3:300\n1#3:303\n*S KotlinDebug\n*F\n+ 1 DefaultRealtimeObjects.kt\nio/ably/lib/objects/DefaultRealtimeObjects\n*L\n104#1:300,3\n*E\n"})
public final class DefaultRealtimeObjects
implements RealtimeObjects {
    @NotNull
    private final String channelName;
    @NotNull
    private final ObjectsAdapter adapter;
    @NotNull
    private final String tag;
    @NotNull
    private final ObjectsPool objectsPool;
    @NotNull
    private ObjectsState state;
    @NotNull
    private final ObjectsManager objectsManager;
    @NotNull
    private final CoroutineScope sequentialScope;
    @NotNull
    private final MutableSharedFlow<ProtocolMessage> objectsEventBus;
    @NotNull
    private final Job incomingObjectsHandler;
    @NotNull
    private final ObjectsAsyncScope asyncScope;

    public DefaultRealtimeObjects(@NotNull String channelName, @NotNull ObjectsAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.channelName = channelName;
        this.adapter = adapter;
        this.tag = "DefaultRealtimeObjects";
        this.objectsPool = new ObjectsPool(this);
        this.state = ObjectsState.Initialized;
        this.objectsManager = new ObjectsManager(this);
        this.sequentialScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getDefault(), (int)1, null, (int)2, null).plus((CoroutineContext)new CoroutineName(this.channelName)).plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.objectsEventBus = SharedFlowKt.MutableSharedFlow$default((int)0, (int)Integer.MAX_VALUE, null, (int)5, null);
        this.asyncScope = new ObjectsAsyncScope(this.channelName);
        this.incomingObjectsHandler = this.initializeHandlerForIncomingObjectMessages();
    }

    @NotNull
    public final String getChannelName$liveobjects() {
        return this.channelName;
    }

    @NotNull
    public final ObjectsAdapter getAdapter$liveobjects() {
        return this.adapter;
    }

    @NotNull
    public final ObjectsPool getObjectsPool$liveobjects() {
        return this.objectsPool;
    }

    @NotNull
    public final ObjectsState getState$liveobjects() {
        return this.state;
    }

    public final void setState$liveobjects(@NotNull ObjectsState objectsState) {
        Intrinsics.checkNotNullParameter((Object)((Object)objectsState), (String)"<set-?>");
        this.state = objectsState;
    }

    @NotNull
    public final ObjectsAsyncScope getAsyncScope$liveobjects() {
        return this.asyncScope;
    }

    @NotNull
    public LiveMap getRoot() {
        return (LiveMap)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LiveMap>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultRealtimeObjects.access$getRootAsync(this.this$0, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LiveMap> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public LiveMap createMap() {
        return this.createMap(new LinkedHashMap());
    }

    @NotNull
    public LiveMap createMap(@NotNull Map<String, LiveMapValue> entries2) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        return (LiveMap)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LiveMap>, Object>(this, entries2, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            final /* synthetic */ Map<String, LiveMapValue> $entries;
            {
                this.this$0 = $receiver;
                this.$entries = $entries;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultRealtimeObjects.access$createMapAsync(this.this$0, this.$entries, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LiveMap> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public LiveCounter createCounter() {
        return this.createCounter(0);
    }

    @NotNull
    public LiveCounter createCounter(@NotNull Number initialValue) {
        Intrinsics.checkNotNullParameter((Object)initialValue, (String)"initialValue");
        return (LiveCounter)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LiveCounter>, Object>(this, initialValue, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            final /* synthetic */ Number $initialValue;
            {
                this.this$0 = $receiver;
                this.$initialValue = $initialValue;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultRealtimeObjects.access$createCounterAsync(this.this$0, this.$initialValue, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LiveCounter> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void getRootAsync(@NotNull ObjectsCallback<LiveMap> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.asyncScope.launchWithCallback$liveobjects(callback, (Function1)new Function1<Continuation<? super LiveMap>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultRealtimeObjects.access$getRootAsync(this.this$0, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super LiveMap> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public void createMapAsync(@NotNull ObjectsCallback<LiveMap> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.createMapAsync((Map<String, LiveMapValue>)new LinkedHashMap(), callback);
    }

    public void createMapAsync(@NotNull Map<String, LiveMapValue> entries2, @NotNull ObjectsCallback<LiveMap> callback) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.asyncScope.launchWithCallback$liveobjects(callback, (Function1)new Function1<Continuation<? super LiveMap>, Object>(this, entries2, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            final /* synthetic */ Map<String, LiveMapValue> $entries;
            {
                this.this$0 = $receiver;
                this.$entries = $entries;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultRealtimeObjects.access$createMapAsync(this.this$0, this.$entries, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super LiveMap> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public void createCounterAsync(@NotNull ObjectsCallback<LiveCounter> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.createCounterAsync((Number)0, callback);
    }

    public void createCounterAsync(@NotNull Number initialValue, @NotNull ObjectsCallback<LiveCounter> callback) {
        Intrinsics.checkNotNullParameter((Object)initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.asyncScope.launchWithCallback$liveobjects(callback, (Function1)new Function1<Continuation<? super LiveCounter>, Object>(this, initialValue, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            final /* synthetic */ Number $initialValue;
            {
                this.this$0 = $receiver;
                this.$initialValue = $initialValue;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultRealtimeObjects.access$createCounterAsync(this.this$0, this.$initialValue, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super LiveCounter> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public ObjectsSubscription on(@NotNull ObjectsStateEvent event, @NotNull ObjectsStateChange.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.objectsManager.on(event, listener);
    }

    public void off(@NotNull ObjectsStateChange.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.objectsManager.off(listener);
    }

    public void offAll() {
        this.objectsManager.offAll();
    }

    private final Object getRootAsync(Continuation<? super LiveMap> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.sequentialScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LiveMap>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        HelpersKt.throwIfInvalidAccessApiConfiguration(this.this$0.getAdapter$liveobjects(), this.this$0.getChannelName$liveobjects());
                        this.label = 1;
                        v0 = HelpersKt.ensureAttached(this.this$0.getAdapter$liveobjects(), this.this$0.getChannelName$liveobjects(), (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.label = 2;
                        v1 = DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).ensureSynced(this.this$0.getState$liveobjects(), (Continuation<? super Unit>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        v2 = this.this$0.getObjectsPool$liveobjects().get$liveobjects("root");
                        Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type io.ably.lib.objects.type.map.LiveMap");
                        return (LiveMap)v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LiveMap> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object createMapAsync(Map<String, LiveMapValue> var1_1, Continuation<? super LiveMap> $completion) {
        if (!($completion instanceof createMapAsync.2)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultRealtimeObjects this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultRealtimeObjects.access$createMapAsync(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                HelpersKt.throwIfInvalidWriteApiConfiguration(this.adapter, this.channelName);
                $this$any$iv = entries.keySet();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl18
                v0 = false;
                ** GOTO lbl26
lbl18:
                // 2 sources

                for (E element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    $i$a$-any-DefaultRealtimeObjects$createMapAsync$3 = false;
                    v1 = ((CharSequence)it).length() == 0;
                    if (!v1) continue;
                    v0 = true;
                    ** GOTO lbl26
                }
                v0 = false;
lbl26:
                // 3 sources

                if (v0) {
                    throw UtilsKt.invalidInputError$default("Map keys should not be empty", null, 2, null);
                }
                initialMapValue = DefaultLiveMap.Companion.initialValue$liveobjects((Map<String, LiveMapValue>)entries);
                initialValueJSONString = JsonSerializationKt.getGson().toJson((Object)initialMapValue);
                Intrinsics.checkNotNull((Object)initialValueJSONString);
                $continuation.L$0 = this;
                $continuation.L$1 = initialMapValue;
                $continuation.L$2 = initialValueJSONString;
                $continuation.label = 1;
                v2 = this.getObjectIdStringWithNonce(ObjectType.Map, initialValueJSONString, (Continuation<? super Pair<String, String>>)$continuation);
                if (v2 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl45
            }
            case 1: {
                initialValueJSONString = (String)$continuation.L$2;
                initialMapValue = (MapCreatePayload)$continuation.L$1;
                this = (DefaultRealtimeObjects)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl45:
                // 2 sources

                var5_9 = (Pair)v2;
                objectId = (String)var5_9.component1();
                nonce = (String)var5_9.component2();
                msg = new ObjectMessage(null, null, null, null, null, new ObjectOperation(ObjectOperationAction.MapCreate, objectId, null, null, initialMapValue.getMap(), null, nonce, initialValueJSONString, 44, null), null, null, null, null, 991, null);
                var9_14 = new ObjectMessage[]{msg};
                $continuation.L$0 = this;
                $continuation.L$1 = objectId;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v3 = this.publish$liveobjects(var9_14, (Continuation<? super Unit>)$continuation);
                if (v3 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl63
            }
            case 2: {
                objectId = (String)$continuation.L$1;
                this = (DefaultRealtimeObjects)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl63:
                // 2 sources

                v4 = (var10_15 = this.objectsPool.get$liveobjects(objectId)) instanceof LiveMap != false ? (LiveMap)var10_15 : null;
                if (v4 != null) break;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v5 = BuildersKt.withContext((CoroutineContext)this.sequentialScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LiveMap>, Object>(this, objectId, null){
                    int label;
                    final /* synthetic */ DefaultRealtimeObjects this$0;
                    final /* synthetic */ String $objectId;
                    {
                        this.this$0 = $receiver;
                        this.$objectId = $objectId;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                BaseRealtimeObject baseRealtimeObject = this.this$0.getObjectsPool$liveobjects().createZeroValueObjectIfNotExists$liveobjects(this.$objectId);
                                Intrinsics.checkNotNull((Object)baseRealtimeObject, (String)"null cannot be cast to non-null type io.ably.lib.objects.type.map.LiveMap");
                                return (LiveMap)baseRealtimeObject;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super LiveMap> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v5 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl75
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl75:
                // 2 sources

                return v5;
            }
        }
        return v4;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object createCounterAsync(Number var1_1, Continuation<? super LiveCounter> $completion) {
        if (!($completion instanceof createCounterAsync.2)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultRealtimeObjects this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultRealtimeObjects.access$createCounterAsync(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                HelpersKt.throwIfInvalidWriteApiConfiguration(this.adapter, this.channelName);
                if (Double.isNaN(initialValue.doubleValue()) || Double.isInfinite(initialValue.doubleValue())) {
                    throw UtilsKt.invalidInputError$default("Counter value should be a valid number", null, 2, null);
                }
                initialCounterValue = DefaultLiveCounter.Companion.initialValue$liveobjects((Number)initialValue);
                initialValueJSONString = JsonSerializationKt.getGson().toJson((Object)initialCounterValue);
                Intrinsics.checkNotNull((Object)initialValueJSONString);
                $continuation.L$0 = this;
                $continuation.L$1 = initialCounterValue;
                $continuation.L$2 = initialValueJSONString;
                $continuation.label = 1;
                v0 = this.getObjectIdStringWithNonce(ObjectType.Counter, initialValueJSONString, (Continuation<? super Pair<String, String>>)$continuation);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                initialValueJSONString = (String)$continuation.L$2;
                initialCounterValue = (CounterCreatePayload)$continuation.L$1;
                this = (DefaultRealtimeObjects)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                var5_8 = (Pair)v0;
                objectId = (String)var5_8.component1();
                nonce = (String)var5_8.component2();
                msg = new ObjectMessage(null, null, null, null, null, new ObjectOperation(ObjectOperationAction.CounterCreate, objectId, null, null, null, initialCounterValue.getCounter(), nonce, initialValueJSONString, 28, null), null, null, null, null, 991, null);
                var9_12 = new ObjectMessage[]{msg};
                $continuation.L$0 = this;
                $continuation.L$1 = objectId;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = this.publish$liveobjects(var9_12, (Continuation<? super Unit>)$continuation);
                if (v1 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl50
            }
            case 2: {
                objectId = (String)$continuation.L$1;
                this = (DefaultRealtimeObjects)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl50:
                // 2 sources

                v2 = (var10_13 = this.objectsPool.get$liveobjects(objectId)) instanceof LiveCounter != false ? (LiveCounter)var10_13 : null;
                if (v2 != null) break;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v3 = BuildersKt.withContext((CoroutineContext)this.sequentialScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LiveCounter>, Object>(this, objectId, null){
                    int label;
                    final /* synthetic */ DefaultRealtimeObjects this$0;
                    final /* synthetic */ String $objectId;
                    {
                        this.this$0 = $receiver;
                        this.$objectId = $objectId;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                BaseRealtimeObject baseRealtimeObject = this.this$0.getObjectsPool$liveobjects().createZeroValueObjectIfNotExists$liveobjects(this.$objectId);
                                Intrinsics.checkNotNull((Object)baseRealtimeObject, (String)"null cannot be cast to non-null type io.ably.lib.objects.type.counter.LiveCounter");
                                return (LiveCounter)baseRealtimeObject;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super LiveCounter> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl62
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl62:
                // 2 sources

                return v3;
            }
        }
        return v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getObjectIdStringWithNonce(ObjectType var1_1, String var2_2, Continuation<? super Pair<String, String>> $completion) {
        if (!($completion instanceof getObjectIdStringWithNonce.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultRealtimeObjects this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultRealtimeObjects.access$getObjectIdStringWithNonce(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                nonce = UtilsKt.generateNonce();
                $continuation.L$0 = objectType;
                $continuation.L$1 = initialValue;
                $continuation.L$2 = nonce;
                $continuation.label = 1;
                v0 = ServerTime.INSTANCE.getCurrentTime$liveobjects(this.adapter, (Continuation<? super Long>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                nonce = (String)$continuation.L$2;
                initialValue = (String)$continuation.L$1;
                objectType = (ObjectType)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                msTimestamp = ((Number)v0).longValue();
                return new Pair((Object)ObjectId.Companion.fromInitialValue$liveobjects(objectType, initialValue, nonce, msTimestamp).toString(), (Object)nonce);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object publish$liveobjects(@NotNull ObjectMessage[] objectMessages, @NotNull Continuation<? super Unit> $completion) {
        HelpersKt.throwIfUnpublishableState(this.adapter, this.channelName);
        HelpersKt.ensureMessageSizeWithinLimit(this.adapter, objectMessages);
        ProtocolMessage protocolMessage = new ProtocolMessage(ProtocolMessage.Action.object, this.channelName);
        protocolMessage.state = objectMessages;
        Object object = HelpersKt.sendAsync(this.adapter, protocolMessage, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void handle$liveobjects(@NotNull ProtocolMessage protocolMessage) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)protocolMessage, (String)"protocolMessage");
                HelpersKt.setChannelSerial(this.adapter, this.channelName, protocolMessage);
                if (protocolMessage.state == null) break block2;
                Intrinsics.checkNotNullExpressionValue((Object)protocolMessage.state, (String)"state");
                if (!(protocolMessage.state.length == 0)) break block3;
            }
            Log.w((String)this.tag, (String)"Received ProtocolMessage with null or empty objects, ignoring");
            return;
        }
        this.objectsEventBus.tryEmit((Object)protocolMessage);
    }

    private final Job initializeHandlerForIncomingObjectMessages() {
        return BuildersKt.launch$default((CoroutineScope)this.sequentialScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultRealtimeObjects.access$getObjectsEventBus$p(this.this$0).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ DefaultRealtimeObjects this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(ProtocolMessage protocolMessage, Continuation<? super Unit> $completion) {
                                void $this$mapIndexedTo$iv$iv;
                                void $this$mapIndexed$iv;
                                void $this$filterIsInstanceTo$iv$iv;
                                Intrinsics.checkNotNullExpressionValue((Object)protocolMessage.state, (String)"state");
                                Object $this$filterIsInstance$iv = protocolMessage.state;
                                boolean $i$f$filterIsInstance = false;
                                Object[] objectArray = $this$filterIsInstance$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterIsInstanceTo = false;
                                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                    if (!(element$iv$iv instanceof ObjectMessage)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filterIsInstance$iv = (List)destination$iv$iv;
                                boolean $i$f$mapIndexed = false;
                                $this$filterIsInstanceTo$iv$iv = $this$mapIndexed$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                                boolean $i$f$mapIndexedTo = false;
                                int index$iv$iv = 0;
                                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                                    void objMsg;
                                    int n;
                                    if ((n = index$iv$iv++) < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    ObjectMessage objectMessage = (ObjectMessage)item$iv$iv;
                                    int n2 = n;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    String string = objMsg.getConnectionId();
                                    if (string == null) {
                                        string = protocolMessage.connectionId;
                                    }
                                    String string2 = string;
                                    Long l = objMsg.getTimestamp();
                                    long l2 = l != null ? l : protocolMessage.timestamp;
                                    Object object = objMsg.getId();
                                    if (object == null) {
                                        void index;
                                        object = protocolMessage.id + ":" + (int)index;
                                    }
                                    String string3 = object;
                                    collection.add(ObjectMessage.copy$default((ObjectMessage)objMsg, string3, Boxing.boxLong((long)l2), null, string2, null, null, null, null, null, null, 1012, null));
                                }
                                List objects = (List)destination$iv$iv;
                                try {
                                    ProtocolMessage.Action action = protocolMessage.action;
                                    switch (action == null ? -1 : initializeHandlerForIncomingObjectMessages.WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                                        case 1: {
                                            DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).handleObjectMessages$liveobjects(objects);
                                            break;
                                        }
                                        case 2: {
                                            DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).handleObjectSyncMessages$liveobjects(objects, protocolMessage.channelSerial);
                                            break;
                                        }
                                        default: {
                                            Boxing.boxInt((int)Log.w((String)DefaultRealtimeObjects.access$getTag$p(this.this$0), (String)("Ignoring protocol message with unhandled action: " + protocolMessage.action)));
                                            break;
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    Boxing.boxInt((int)Log.e((String)DefaultRealtimeObjects.access$getTag$p(this.this$0), (String)("Error handling objects message with protocolMsg id " + protocolMessage.id), (Throwable)exception));
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void handleStateChange$liveobjects(@NotNull ChannelState state, boolean hasObjects) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BuildersKt.launch$default((CoroutineScope)this.sequentialScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(state, this, hasObjects, null){
            int label;
            final /* synthetic */ ChannelState $state;
            final /* synthetic */ DefaultRealtimeObjects this$0;
            final /* synthetic */ boolean $hasObjects;
            {
                this.$state = $state;
                this.this$0 = $receiver;
                this.$hasObjects = $hasObjects;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        switch (handleStateChange.WhenMappings.$EnumSwitchMapping$0[this.$state.ordinal()]) {
                            case 1: {
                                boolean fromInitializedState;
                                Log.v((String)DefaultRealtimeObjects.access$getTag$p(this.this$0), (String)("Objects.onAttached() channel=" + this.this$0.getChannelName$liveobjects() + ", hasObjects=" + this.$hasObjects));
                                boolean bl = fromInitializedState = this.this$0.getState$liveobjects() == ObjectsState.Initialized;
                                if (this.$hasObjects || fromInitializedState) {
                                    DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).startNewSync$liveobjects(null);
                                }
                                if (this.$hasObjects) break;
                                this.this$0.getObjectsPool$liveobjects().resetToInitialPool$liveobjects(true);
                                DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).clearSyncObjectsDataPool$liveobjects();
                                DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).clearBufferedObjectOperations$liveobjects();
                                DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).endSync$liveobjects(fromInitializedState);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.this$0.getObjectsPool$liveobjects().clearObjectsData$liveobjects(false);
                                DefaultRealtimeObjects.access$getObjectsManager$p(this.this$0).clearSyncObjectsDataPool$liveobjects();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void dispose(@NotNull AblyException cause) {
        CancellationException cancellationException;
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        CancellationException $this$dispose_u24lambda_u241 = cancellationException = new CancellationException();
        boolean bl = false;
        $this$dispose_u24lambda_u241.initCause((Throwable)cause);
        CancellationException disposeReason = cancellationException;
        this.incomingObjectsHandler.cancel(disposeReason);
        this.objectsPool.dispose();
        this.objectsManager.dispose$liveobjects();
        JobKt.cancelChildren((CoroutineContext)this.sequentialScope.getCoroutineContext(), (CancellationException)disposeReason);
        this.asyncScope.cancel$liveobjects(disposeReason);
    }

    public static final /* synthetic */ Object access$getRootAsync(DefaultRealtimeObjects $this, Continuation $completion) {
        return $this.getRootAsync((Continuation<? super LiveMap>)$completion);
    }

    public static final /* synthetic */ Object access$createMapAsync(DefaultRealtimeObjects $this, Map entries2, Continuation $completion) {
        return $this.createMapAsync((Map<String, LiveMapValue>)entries2, (Continuation<? super LiveMap>)$completion);
    }

    public static final /* synthetic */ Object access$createCounterAsync(DefaultRealtimeObjects $this, Number initialValue, Continuation $completion) {
        return $this.createCounterAsync(initialValue, (Continuation<? super LiveCounter>)$completion);
    }

    public static final /* synthetic */ ObjectsManager access$getObjectsManager$p(DefaultRealtimeObjects $this) {
        return $this.objectsManager;
    }

    public static final /* synthetic */ Object access$getObjectIdStringWithNonce(DefaultRealtimeObjects $this, ObjectType objectType, String initialValue, Continuation $completion) {
        return $this.getObjectIdStringWithNonce(objectType, initialValue, (Continuation<? super Pair<String, String>>)$completion);
    }

    public static final /* synthetic */ MutableSharedFlow access$getObjectsEventBus$p(DefaultRealtimeObjects $this) {
        return $this.objectsEventBus;
    }

    public static final /* synthetic */ String access$getTag$p(DefaultRealtimeObjects $this) {
        return $this.tag;
    }
}

