/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.type.livemap;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.ably.lib.objects.ObjectData;
import io.ably.lib.objects.ObjectValue;
import io.ably.lib.objects.ObjectsPool;
import io.ably.lib.objects.type.BaseRealtimeObject;
import io.ably.lib.objects.type.ObjectType;
import io.ably.lib.objects.type.counter.LiveCounter;
import io.ably.lib.objects.type.livemap.LiveMapEntry;
import io.ably.lib.objects.type.map.LiveMap;
import io.ably.lib.objects.type.map.LiveMapValue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"isEntryOrRefTombstoned", "", "Lio/ably/lib/objects/type/livemap/LiveMapEntry;", "objectsPool", "Lio/ably/lib/objects/ObjectsPool;", "getResolvedValue", "Lio/ably/lib/objects/type/map/LiveMapValue;", "isEligibleForGc", "fromObjectValue", "objValue", "Lio/ably/lib/objects/ObjectValue;", "fromRealtimeObject", "realtimeObject", "Lio/ably/lib/objects/type/BaseRealtimeObject;", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nLiveMapEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapEntry.kt\nio/ably/lib/objects/type/livemap/LiveMapEntryKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class LiveMapEntryKt {
    public static final boolean isEntryOrRefTombstoned(@NotNull LiveMapEntry $this$isEntryOrRefTombstoned, @NotNull ObjectsPool objectsPool) {
        Intrinsics.checkNotNullParameter((Object)$this$isEntryOrRefTombstoned, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectsPool, (String)"objectsPool");
        if ($this$isEntryOrRefTombstoned.isTombstoned()) {
            return true;
        }
        Object object = $this$isEntryOrRefTombstoned.getData();
        if (object != null && (object = ((ObjectData)object).getObjectId()) != null) {
            Object refId = object;
            boolean bl = false;
            BaseRealtimeObject baseRealtimeObject = objectsPool.get$liveobjects((String)refId);
            if (baseRealtimeObject != null) {
                BaseRealtimeObject refObject = baseRealtimeObject;
                boolean bl2 = false;
                if (refObject.isTombstoned$liveobjects()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static final LiveMapValue getResolvedValue(@NotNull LiveMapEntry $this$getResolvedValue, @NotNull ObjectsPool objectsPool) {
        ObjectValue objectValue;
        Intrinsics.checkNotNullParameter((Object)$this$getResolvedValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectsPool, (String)"objectsPool");
        if ($this$getResolvedValue.isTombstoned()) {
            return null;
        }
        ObjectData objectData = $this$getResolvedValue.getData();
        if (objectData != null && (objectValue = objectData.getValue()) != null) {
            ObjectValue it = objectValue;
            boolean bl = false;
            return LiveMapEntryKt.fromObjectValue(it);
        }
        Object object = $this$getResolvedValue.getData();
        if (object != null && (object = ((ObjectData)object).getObjectId()) != null) {
            Object refId = object;
            boolean bl = false;
            BaseRealtimeObject baseRealtimeObject = objectsPool.get$liveobjects((String)refId);
            if (baseRealtimeObject != null) {
                BaseRealtimeObject refObject = baseRealtimeObject;
                boolean bl2 = false;
                if (refObject.isTombstoned$liveobjects()) {
                    return null;
                }
                return LiveMapEntryKt.fromRealtimeObject(refObject);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEligibleForGc(@NotNull LiveMapEntry $this$isEligibleForGc) {
        Intrinsics.checkNotNullParameter((Object)$this$isEligibleForGc, (String)"<this>");
        long currentTime = System.currentTimeMillis();
        if (!$this$isEligibleForGc.isTombstoned()) return false;
        Long l = $this$isEligibleForGc.getTombstonedAt();
        if (l == null) return false;
        long it = ((Number)l).longValue();
        boolean bl = false;
        if (currentTime - it < 86400000L) return false;
        return true;
    }

    private static final LiveMapValue fromObjectValue(ObjectValue objValue) {
        LiveMapValue liveMapValue;
        ObjectValue objectValue = objValue;
        if (objectValue instanceof ObjectValue.String) {
            LiveMapValue liveMapValue2 = LiveMapValue.of((String)((ObjectValue.String)objValue).getValue());
            liveMapValue = liveMapValue2;
            Intrinsics.checkNotNullExpressionValue((Object)liveMapValue2, (String)"of(...)");
        } else if (objectValue instanceof ObjectValue.Number) {
            LiveMapValue liveMapValue3 = LiveMapValue.of((Number)((ObjectValue.Number)objValue).getValue());
            liveMapValue = liveMapValue3;
            Intrinsics.checkNotNullExpressionValue((Object)liveMapValue3, (String)"of(...)");
        } else if (objectValue instanceof ObjectValue.Boolean) {
            LiveMapValue liveMapValue4 = LiveMapValue.of((Boolean)((ObjectValue.Boolean)objValue).getValue());
            liveMapValue = liveMapValue4;
            Intrinsics.checkNotNullExpressionValue((Object)liveMapValue4, (String)"of(...)");
        } else if (objectValue instanceof ObjectValue.Binary) {
            LiveMapValue liveMapValue5 = LiveMapValue.of((byte[])((ObjectValue.Binary)objValue).getValue().getData());
            liveMapValue = liveMapValue5;
            Intrinsics.checkNotNullExpressionValue((Object)liveMapValue5, (String)"of(...)");
        } else if (objectValue instanceof ObjectValue.JsonObject) {
            LiveMapValue liveMapValue6 = LiveMapValue.of((JsonObject)((ObjectValue.JsonObject)objValue).getValue());
            liveMapValue = liveMapValue6;
            Intrinsics.checkNotNullExpressionValue((Object)liveMapValue6, (String)"of(...)");
        } else if (objectValue instanceof ObjectValue.JsonArray) {
            LiveMapValue liveMapValue7 = LiveMapValue.of((JsonArray)((ObjectValue.JsonArray)objValue).getValue());
            liveMapValue = liveMapValue7;
            Intrinsics.checkNotNullExpressionValue((Object)liveMapValue7, (String)"of(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return liveMapValue;
    }

    private static final LiveMapValue fromRealtimeObject(BaseRealtimeObject realtimeObject) {
        LiveMapValue liveMapValue;
        switch (WhenMappings.$EnumSwitchMapping$0[realtimeObject.getObjectType$liveobjects().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)realtimeObject, (String)"null cannot be cast to non-null type io.ably.lib.objects.type.map.LiveMap");
                LiveMapValue liveMapValue2 = LiveMapValue.of((LiveMap)((LiveMap)realtimeObject));
                liveMapValue = liveMapValue2;
                Intrinsics.checkNotNullExpressionValue((Object)liveMapValue2, (String)"of(...)");
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)realtimeObject, (String)"null cannot be cast to non-null type io.ably.lib.objects.type.counter.LiveCounter");
                LiveMapValue liveMapValue3 = LiveMapValue.of((LiveCounter)((LiveCounter)realtimeObject));
                liveMapValue = liveMapValue3;
                Intrinsics.checkNotNullExpressionValue((Object)liveMapValue3, (String)"of(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return liveMapValue;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObjectType.values().length];
            try {
                nArray[ObjectType.Map.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectType.Counter.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

