/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.type.livecounter;

import io.ably.lib.objects.CounterCreatePayload;
import io.ably.lib.objects.DefaultRealtimeObjects;
import io.ably.lib.objects.HelpersKt;
import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectOperationAction;
import io.ably.lib.objects.ObjectState;
import io.ably.lib.objects.ObjectsAdapter;
import io.ably.lib.objects.ObjectsAsyncScope;
import io.ably.lib.objects.ObjectsCallback;
import io.ably.lib.objects.ObjectsCounter;
import io.ably.lib.objects.ObjectsCounterOp;
import io.ably.lib.objects.ObjectsSubscription;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.type.BaseRealtimeObject;
import io.ably.lib.objects.type.BaseRealtimeObjectKt;
import io.ably.lib.objects.type.ObjectType;
import io.ably.lib.objects.type.ObjectUpdate;
import io.ably.lib.objects.type.counter.LiveCounter;
import io.ably.lib.objects.type.counter.LiveCounterChange;
import io.ably.lib.objects.type.counter.LiveCounterUpdate;
import io.ably.lib.objects.type.livecounter.LiveCounterManager;
import io.ably.lib.util.Log;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u001e\u0010%\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020\u001dH\u0016J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u0002082\u0006\u00104\u001a\u000205H\u0016J\b\u00109\u001a\u000202H\u0016J\u0010\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006?"}, d2={"Lio/ably/lib/objects/type/livecounter/DefaultLiveCounter;", "Lio/ably/lib/objects/type/counter/LiveCounter;", "Lio/ably/lib/objects/type/BaseRealtimeObject;", "objectId", "", "realtimeObjects", "Lio/ably/lib/objects/DefaultRealtimeObjects;", "<init>", "(Ljava/lang/String;Lio/ably/lib/objects/DefaultRealtimeObjects;)V", "tag", "getTag", "()Ljava/lang/String;", "data", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getData$liveobjects", "()Ljava/util/concurrent/atomic/AtomicReference;", "liveCounterManager", "Lio/ably/lib/objects/type/livecounter/LiveCounterManager;", "channelName", "adapter", "Lio/ably/lib/objects/ObjectsAdapter;", "getAdapter", "()Lio/ably/lib/objects/ObjectsAdapter;", "asyncScope", "Lio/ably/lib/objects/ObjectsAsyncScope;", "getAsyncScope", "()Lio/ably/lib/objects/ObjectsAsyncScope;", "increment", "", "amount", "", "decrement", "incrementAsync", "callback", "Lio/ably/lib/objects/ObjectsCallback;", "Ljava/lang/Void;", "decrementAsync", "value", "subscribe", "Lio/ably/lib/objects/ObjectsSubscription;", "listener", "Lio/ably/lib/objects/type/counter/LiveCounterChange$Listener;", "unsubscribe", "unsubscribeAll", "validate", "state", "Lio/ably/lib/objects/ObjectState;", "(DLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyObjectState", "Lio/ably/lib/objects/type/counter/LiveCounterUpdate;", "objectState", "message", "Lio/ably/lib/objects/ObjectMessage;", "applyObjectOperation", "operation", "Lio/ably/lib/objects/ObjectOperation;", "clearData", "notifyUpdated", "update", "Lio/ably/lib/objects/type/ObjectUpdate;", "onGCInterval", "Companion", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nDefaultLiveCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLiveCounter.kt\nio/ably/lib/objects/type/livecounter/DefaultLiveCounter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class DefaultLiveCounter
extends BaseRealtimeObject
implements LiveCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultRealtimeObjects realtimeObjects;
    @NotNull
    private final String tag;
    @NotNull
    private final AtomicReference<Double> data;
    @NotNull
    private final LiveCounterManager liveCounterManager;
    @NotNull
    private final String channelName;

    private DefaultLiveCounter(String objectId, DefaultRealtimeObjects realtimeObjects) {
        super(objectId, ObjectType.Counter);
        this.realtimeObjects = realtimeObjects;
        this.tag = "LiveCounter";
        this.data = new AtomicReference<Double>(0.0);
        this.liveCounterManager = new LiveCounterManager(this);
        this.channelName = this.realtimeObjects.getChannelName$liveobjects();
    }

    @Override
    @NotNull
    protected String getTag() {
        return this.tag;
    }

    @NotNull
    public final AtomicReference<Double> getData$liveobjects() {
        return this.data;
    }

    private final ObjectsAdapter getAdapter() {
        return this.realtimeObjects.getAdapter$liveobjects();
    }

    private final ObjectsAsyncScope getAsyncScope() {
        return this.realtimeObjects.getAsyncScope$liveobjects();
    }

    public void increment(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, amount, null){
            int label;
            final /* synthetic */ DefaultLiveCounter this$0;
            final /* synthetic */ Number $amount;
            {
                this.this$0 = $receiver;
                this.$amount = $amount;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultLiveCounter.access$incrementAsync(this.this$0, this.$amount.doubleValue(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void decrement(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, amount, null){
            int label;
            final /* synthetic */ DefaultLiveCounter this$0;
            final /* synthetic */ Number $amount;
            {
                this.this$0 = $receiver;
                this.$amount = $amount;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultLiveCounter.access$incrementAsync(this.this$0, -this.$amount.doubleValue(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void incrementAsync(@NotNull Number amount, @NotNull ObjectsCallback<Void> callback) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.getAsyncScope().launchWithVoidCallback$liveobjects(callback, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, amount, null){
            int label;
            final /* synthetic */ DefaultLiveCounter this$0;
            final /* synthetic */ Number $amount;
            {
                this.this$0 = $receiver;
                this.$amount = $amount;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultLiveCounter.access$incrementAsync(this.this$0, this.$amount.doubleValue(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void decrementAsync(@NotNull Number amount, @NotNull ObjectsCallback<Void> callback) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.getAsyncScope().launchWithVoidCallback$liveobjects(callback, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, amount, null){
            int label;
            final /* synthetic */ DefaultLiveCounter this$0;
            final /* synthetic */ Number $amount;
            {
                this.this$0 = $receiver;
                this.$amount = $amount;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultLiveCounter.access$incrementAsync(this.this$0, -this.$amount.doubleValue(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public double value() {
        HelpersKt.throwIfInvalidAccessApiConfiguration(this.getAdapter(), this.channelName);
        Double d = this.data.get();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public ObjectsSubscription subscribe(@NotNull LiveCounterChange.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        HelpersKt.throwIfInvalidAccessApiConfiguration(this.getAdapter(), this.channelName);
        return this.liveCounterManager.subscribe(listener);
    }

    public void unsubscribe(@NotNull LiveCounterChange.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.liveCounterManager.unsubscribe(listener);
    }

    public void unsubscribeAll() {
        this.liveCounterManager.unsubscribeAll();
    }

    @Override
    public void validate(@NotNull ObjectState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.liveCounterManager.validate$liveobjects(state);
    }

    private final Object incrementAsync(double amount, Continuation<? super Unit> $completion) {
        HelpersKt.throwIfInvalidWriteApiConfiguration(this.getAdapter(), this.channelName);
        if (Double.isNaN(amount) || Double.isInfinite(amount)) {
            throw UtilsKt.invalidInputError$default("Counter value increment should be a valid number", null, 2, null);
        }
        ObjectMessage msg = new ObjectMessage(null, null, null, null, null, new ObjectOperation(ObjectOperationAction.CounterInc, this.getObjectId$liveobjects(), null, new ObjectsCounterOp(Boxing.boxDouble((double)amount)), null, null, null, null, 244, null), null, null, null, null, 991, null);
        ObjectMessage[] objectMessageArray = new ObjectMessage[]{msg};
        Object object = this.realtimeObjects.publish$liveobjects(objectMessageArray, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public LiveCounterUpdate applyObjectState(@NotNull ObjectState objectState, @NotNull ObjectMessage message) {
        Intrinsics.checkNotNullParameter((Object)objectState, (String)"objectState");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.liveCounterManager.applyState$liveobjects(objectState, message.getSerialTimestamp());
    }

    @Override
    public void applyObjectOperation(@NotNull ObjectOperation operation, @NotNull ObjectMessage message) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.liveCounterManager.applyOperation$liveobjects(operation, message.getSerialTimestamp());
    }

    @NotNull
    public LiveCounterUpdate clearData() {
        LiveCounterUpdate liveCounterUpdate;
        Double d = this.data.get();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
        LiveCounterUpdate $this$clearData_u24lambda_u240 = liveCounterUpdate = this.liveCounterManager.calculateUpdateFromDataDiff$liveobjects(((Number)d).doubleValue(), 0.0);
        boolean bl = false;
        this.data.set(0.0);
        return liveCounterUpdate;
    }

    @Override
    public void notifyUpdated(@NotNull ObjectUpdate update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        if (BaseRealtimeObjectKt.getNoOp(update)) {
            return;
        }
        Log.v((String)this.getTag(), (String)("Object " + this.getObjectId$liveobjects() + " updated: " + update));
        this.liveCounterManager.notify((LiveCounterUpdate)update);
    }

    @Override
    public void onGCInterval() {
    }

    public static final /* synthetic */ Object access$incrementAsync(DefaultLiveCounter $this, double amount, Continuation $completion) {
        return $this.incrementAsync(amount, (Continuation<? super Unit>)$completion);
    }

    public /* synthetic */ DefaultLiveCounter(String objectId, DefaultRealtimeObjects realtimeObjects, DefaultConstructorMarker $constructor_marker) {
        this(objectId, realtimeObjects);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lio/ably/lib/objects/type/livecounter/DefaultLiveCounter$Companion;", "", "<init>", "()V", "zeroValue", "Lio/ably/lib/objects/type/livecounter/DefaultLiveCounter;", "objectId", "", "realtimeObjects", "Lio/ably/lib/objects/DefaultRealtimeObjects;", "zeroValue$liveobjects", "initialValue", "Lio/ably/lib/objects/CounterCreatePayload;", "count", "", "initialValue$liveobjects", "liveobjects"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DefaultLiveCounter zeroValue$liveobjects(@NotNull String objectId, @NotNull DefaultRealtimeObjects realtimeObjects) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)realtimeObjects, (String)"realtimeObjects");
            return new DefaultLiveCounter(objectId, realtimeObjects, null);
        }

        @NotNull
        public final CounterCreatePayload initialValue$liveobjects(@NotNull Number count) {
            Intrinsics.checkNotNullParameter((Object)count, (String)"count");
            return new CounterCreatePayload(new ObjectsCounter(count.doubleValue()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

