/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.type;

import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectState;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.type.ObjectLifecycle;
import io.ably.lib.objects.type.ObjectLifecycleCoordinator;
import io.ably.lib.objects.type.ObjectType;
import io.ably.lib.objects.type.ObjectUpdate;
import io.ably.lib.objects.type.livecounter.LiveCounterChangeCoordinatorKt;
import io.ably.lib.objects.type.livemap.LiveMapChangeCoordinatorKt;
import io.ably.lib.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b%J!\u0010&\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010\u00032\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b)J\u0017\u0010*\u001a\u00020$2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b+J\u0019\u0010,\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b1J\u0010\u00102\u001a\u00020$2\u0006\u00103\u001a\u000204H&J\u0018\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u00020!H&J\u0018\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020:2\u0006\u00107\u001a\u00020!H&J\b\u0010;\u001a\u00020\u001fH&J\u0010\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\u001fH&J\b\u0010>\u001a\u00020$H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006?"}, d2={"Lio/ably/lib/objects/type/BaseRealtimeObject;", "Lio/ably/lib/objects/type/ObjectLifecycleCoordinator;", "objectId", "", "objectType", "Lio/ably/lib/objects/type/ObjectType;", "<init>", "(Ljava/lang/String;Lio/ably/lib/objects/type/ObjectType;)V", "getObjectId$liveobjects", "()Ljava/lang/String;", "getObjectType$liveobjects", "()Lio/ably/lib/objects/type/ObjectType;", "tag", "getTag", "siteTimeserials", "", "getSiteTimeserials$liveobjects", "()Ljava/util/Map;", "createOperationIsMerged", "", "getCreateOperationIsMerged$liveobjects", "()Z", "setCreateOperationIsMerged$liveobjects", "(Z)V", "isTombstoned", "isTombstoned$liveobjects", "setTombstoned$liveobjects", "tombstonedAt", "", "Ljava/lang/Long;", "applyObjectSync", "Lio/ably/lib/objects/type/ObjectUpdate;", "objectMessage", "Lio/ably/lib/objects/ObjectMessage;", "applyObjectSync$liveobjects", "applyObject", "", "applyObject$liveobjects", "canApplyOperation", "siteCode", "timeSerial", "canApplyOperation$liveobjects", "validateObjectId", "validateObjectId$liveobjects", "tombstone", "serialTimestamp", "tombstone$liveobjects", "(Ljava/lang/Long;)Lio/ably/lib/objects/type/ObjectUpdate;", "isEligibleForGc", "isEligibleForGc$liveobjects", "validate", "state", "Lio/ably/lib/objects/ObjectState;", "applyObjectState", "objectState", "message", "applyObjectOperation", "operation", "Lio/ably/lib/objects/ObjectOperation;", "clearData", "notifyUpdated", "update", "onGCInterval", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nBaseRealtimeObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseRealtimeObject.kt\nio/ably/lib/objects/type/BaseRealtimeObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public abstract class BaseRealtimeObject
extends ObjectLifecycleCoordinator {
    @NotNull
    private final String objectId;
    @NotNull
    private final ObjectType objectType;
    @NotNull
    private final String tag;
    @NotNull
    private final Map<String, String> siteTimeserials;
    private boolean createOperationIsMerged;
    private volatile boolean isTombstoned;
    @Nullable
    private Long tombstonedAt;

    public BaseRealtimeObject(@NotNull String objectId, @NotNull ObjectType objectType) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
        this.objectId = objectId;
        this.objectType = objectType;
        this.tag = "BaseRealtimeObject";
        this.siteTimeserials = new LinkedHashMap();
    }

    @NotNull
    public final String getObjectId$liveobjects() {
        return this.objectId;
    }

    @NotNull
    public final ObjectType getObjectType$liveobjects() {
        return this.objectType;
    }

    @NotNull
    protected String getTag() {
        return this.tag;
    }

    @NotNull
    public final Map<String, String> getSiteTimeserials$liveobjects() {
        return this.siteTimeserials;
    }

    public final boolean getCreateOperationIsMerged$liveobjects() {
        return this.createOperationIsMerged;
    }

    public final void setCreateOperationIsMerged$liveobjects(boolean bl) {
        this.createOperationIsMerged = bl;
    }

    public final boolean isTombstoned$liveobjects() {
        return this.isTombstoned;
    }

    public final void setTombstoned$liveobjects(boolean bl) {
        this.isTombstoned = bl;
    }

    @NotNull
    public final ObjectUpdate applyObjectSync$liveobjects(@NotNull ObjectMessage objectMessage) {
        Intrinsics.checkNotNullParameter((Object)objectMessage, (String)"objectMessage");
        ObjectState objectState = objectMessage.getObjectState();
        Intrinsics.checkNotNull((Object)objectState, (String)"null cannot be cast to non-null type io.ably.lib.objects.ObjectState");
        ObjectState objectState2 = objectState;
        this.validate(objectState2);
        this.siteTimeserials.clear();
        this.siteTimeserials.putAll(objectState2.getSiteTimeserials());
        if (this.isTombstoned) {
            if (this.objectType == ObjectType.Map) {
                return (ObjectUpdate)LiveMapChangeCoordinatorKt.getNoOpMapUpdate();
            }
            return (ObjectUpdate)LiveCounterChangeCoordinatorKt.getNoOpCounterUpdate();
        }
        return this.applyObjectState(objectState2, objectMessage);
    }

    public final void applyObject$liveobjects(@NotNull ObjectMessage objectMessage) {
        Intrinsics.checkNotNullParameter((Object)objectMessage, (String)"objectMessage");
        ObjectOperation objectOperation = objectMessage.getOperation();
        this.validateObjectId$liveobjects(objectOperation != null ? objectOperation.getObjectId() : null);
        String msgTimeSerial = objectMessage.getSerial();
        String msgSiteCode = objectMessage.getSiteCode();
        ObjectOperation objectOperation2 = objectMessage.getOperation();
        Intrinsics.checkNotNull((Object)objectOperation2, (String)"null cannot be cast to non-null type io.ably.lib.objects.ObjectOperation");
        ObjectOperation objectOperation3 = objectOperation2;
        if (!this.canApplyOperation$liveobjects(msgSiteCode, msgTimeSerial)) {
            Log.v((String)this.getTag(), (String)("Skipping " + objectOperation3.getAction() + " op: op serial " + msgTimeSerial + " <= site serial " + this.siteTimeserials.get(msgSiteCode) + "; objectId=" + this.objectId));
            return;
        }
        String string = msgSiteCode;
        Intrinsics.checkNotNull((Object)string);
        String string2 = msgTimeSerial;
        Intrinsics.checkNotNull((Object)string2);
        this.siteTimeserials.put(string, string2);
        if (this.isTombstoned) {
            return;
        }
        this.applyObjectOperation(objectOperation3, objectMessage);
    }

    public final boolean canApplyOperation$liveobjects(@Nullable String siteCode, @Nullable String timeSerial) {
        CharSequence charSequence = timeSerial;
        if (charSequence == null || charSequence.length() == 0) {
            throw UtilsKt.objectError$default("Invalid serial: " + timeSerial, null, 2, null);
        }
        charSequence = siteCode;
        if (charSequence == null || charSequence.length() == 0) {
            throw UtilsKt.objectError$default("Invalid site code: " + siteCode, null, 2, null);
        }
        String existingSiteSerial = this.siteTimeserials.get(siteCode);
        return existingSiteSerial == null || timeSerial.compareTo(existingSiteSerial) > 0;
    }

    public final void validateObjectId$liveobjects(@Nullable String objectId) {
        if (!Intrinsics.areEqual((Object)this.objectId, (Object)objectId)) {
            throw UtilsKt.objectError$default("Invalid object: incoming objectId=" + objectId + "; " + this.objectType + " objectId=" + this.objectId, null, 2, null);
        }
    }

    @NotNull
    public final ObjectUpdate tombstone$liveobjects(@Nullable Long serialTimestamp) {
        if (serialTimestamp == null) {
            Log.w((String)this.getTag(), (String)("Tombstoning object " + this.objectId + " without serial timestamp, using local timestamp instead"));
        }
        this.isTombstoned = true;
        Long l = serialTimestamp;
        if (l == null) {
            l = System.currentTimeMillis();
        }
        this.tombstonedAt = l;
        ObjectUpdate update = this.clearData();
        this.objectLifecycleChanged(ObjectLifecycle.Deleted);
        return update;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEligibleForGc$liveobjects() {
        long currentTime = System.currentTimeMillis();
        if (!this.isTombstoned) return false;
        Long l = this.tombstonedAt;
        if (l == null) return false;
        long it = ((Number)l).longValue();
        boolean bl = false;
        if (currentTime - it < 86400000L) return false;
        return true;
    }

    public abstract void validate(@NotNull ObjectState var1);

    @NotNull
    public abstract ObjectUpdate applyObjectState(@NotNull ObjectState var1, @NotNull ObjectMessage var2);

    public abstract void applyObjectOperation(@NotNull ObjectOperation var1, @NotNull ObjectMessage var2);

    @NotNull
    public abstract ObjectUpdate clearData();

    public abstract void notifyUpdated(@NotNull ObjectUpdate var1);

    public abstract void onGCInterval();
}

