/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.objects.Binary;
import io.ably.lib.objects.ObjectData;
import io.ably.lib.objects.ObjectValue;
import java.lang.reflect.Type;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lio/ably/lib/objects/serialization/ObjectDataJsonSerializer;", "Lcom/google/gson/JsonSerializer;", "Lio/ably/lib/objects/ObjectData;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nJsonSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSerialization.kt\nio/ably/lib/objects/serialization/ObjectDataJsonSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class ObjectDataJsonSerializer
implements JsonSerializer<ObjectData>,
JsonDeserializer<ObjectData> {
    @NotNull
    public JsonElement serialize(@NotNull ObjectData src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        JsonObject obj = new JsonObject();
        String string = src.getObjectId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            obj.addProperty("objectId", it);
        }
        ObjectValue objectValue = src.getValue();
        if (objectValue != null) {
            ObjectValue v = objectValue;
            boolean bl = false;
            ObjectValue objectValue2 = v;
            if (objectValue2 instanceof ObjectValue.Boolean) {
                obj.addProperty("boolean", ((ObjectValue.Boolean)v).getValue());
            } else if (objectValue2 instanceof ObjectValue.String) {
                obj.addProperty("string", ((ObjectValue.String)v).getValue());
            } else if (objectValue2 instanceof ObjectValue.Number) {
                obj.addProperty("number", (Number)((ObjectValue.Number)v).getValue().doubleValue());
            } else if (objectValue2 instanceof ObjectValue.Binary) {
                obj.addProperty("bytes", Base64.getEncoder().encodeToString(((ObjectValue.Binary)v).getValue().getData()));
            } else if (objectValue2 instanceof ObjectValue.JsonObject || objectValue2 instanceof ObjectValue.JsonArray) {
                obj.addProperty("json", v.getValue().toString());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (JsonElement)obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public ObjectData deserialize(@NotNull JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        ObjectValue objectValue;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected JsonObject");
        }
        JsonObject obj = json.getAsJsonObject();
        String objectId = obj.has("objectId") ? obj.get("objectId").getAsString() : null;
        if (obj.has("boolean")) {
            objectValue = new ObjectValue.Boolean(obj.get("boolean").getAsBoolean());
        } else if (obj.has("string")) {
            String string = obj.get("string").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            objectValue = new ObjectValue.String(string);
        } else if (obj.has("number")) {
            objectValue = new ObjectValue.Number(obj.get("number").getAsDouble());
        } else if (obj.has("bytes")) {
            byte[] byArray = Base64.getDecoder().decode(obj.get("bytes").getAsString());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            objectValue = new ObjectValue.Binary(new Binary(byArray));
        } else if (obj.has("json")) {
            JsonElement jsonElement = JsonParser.parseString((String)obj.get("json").getAsString());
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                objectValue = new ObjectValue.JsonObject(jsonObject);
            } else {
                if (!jsonElement.isJsonArray()) throw new JsonParseException("Invalid JSON structure");
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                objectValue = new ObjectValue.JsonArray(jsonArray);
            }
        } else {
            if (objectId == null) throw new JsonParseException("Since objectId is not present, at least one of the value fields must be present");
            objectValue = null;
        }
        ObjectValue value = objectValue;
        return new ObjectData(objectId, value);
    }
}

