/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectsSerializer;
import io.ably.lib.objects.serialization.JsonSerializationKt;
import io.ably.lib.objects.serialization.MsgpackSerializationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ%\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00122\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lio/ably/lib/objects/serialization/DefaultObjectsSerializer;", "Lio/ably/lib/objects/ObjectsSerializer;", "<init>", "()V", "readMsgpackArray", "", "", "unpacker", "Lorg/msgpack/core/MessageUnpacker;", "(Lorg/msgpack/core/MessageUnpacker;)[Ljava/lang/Object;", "writeMsgpackArray", "", "objects", "packer", "Lorg/msgpack/core/MessagePacker;", "([Ljava/lang/Object;Lorg/msgpack/core/MessagePacker;)V", "readFromJsonArray", "json", "Lcom/google/gson/JsonArray;", "(Lcom/google/gson/JsonArray;)[Ljava/lang/Object;", "asJsonArray", "([Ljava/lang/Object;)Lcom/google/gson/JsonArray;", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nDefaultSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSerialization.kt\nio/ably/lib/objects/serialization/DefaultObjectsSerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,45:1\n11158#2:46\n11493#2,3:47\n11158#2:60\n11493#2,3:61\n1863#3,2:50\n1557#3:52\n1628#3,3:53\n37#4:56\n36#4,3:57\n*S KotlinDebug\n*F\n+ 1 DefaultSerialization.kt\nio/ably/lib/objects/serialization/DefaultObjectsSerializer\n*L\n24#1:46\n24#1:47,3\n37#1:60\n37#1:61,3\n26#1:50,2\n30#1:52\n30#1:53,3\n33#1:56\n33#1:57,3\n*E\n"})
public final class DefaultObjectsSerializer
implements ObjectsSerializer {
    @NotNull
    public Object[] readMsgpackArray(@NotNull MessageUnpacker unpacker) {
        Intrinsics.checkNotNullParameter((Object)unpacker, (String)"unpacker");
        int objectMessagesCount = unpacker.unpackArrayHeader();
        int n = 0;
        Object[] objectArray = new Object[objectMessagesCount];
        while (n < objectMessagesCount) {
            int n2 = n++;
            objectArray[n2] = MsgpackSerializationKt.readObjectMessage(unpacker);
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public void writeMsgpackArray(@NotNull Object[] objects, @NotNull MessagePacker packer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)packer, (String)"packer");
        Object[] $this$map$iv = objects;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.ably.lib.objects.ObjectMessage");
            collection.add((ObjectMessage)it);
        }
        List objectMessages = (List)destination$iv$iv;
        packer.packArrayHeader(objectMessages.size());
        Iterable $this$forEach$iv = objectMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectMessage it = (ObjectMessage)element$iv;
            boolean bl = false;
            MsgpackSerializationKt.writeMsgpack(it, packer);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] readFromJsonArray(@NotNull JsonArray json) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Iterable $this$map$iv = (Iterable)json;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void element;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!element.isJsonObject()) {
                throw new JsonParseException("Expected JsonObject, but found: " + (JsonElement)element);
            }
            JsonObject jsonObject = element.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            collection.add(JsonSerializationKt.toObjectMessage(jsonObject));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsonArray asJsonArray(@NotNull Object[] objects) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Object[] $this$map$iv = objects;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.ably.lib.objects.ObjectMessage");
            collection.add((ObjectMessage)it);
        }
        List objectMessages = (List)destination$iv$iv;
        JsonArray jsonArray = new JsonArray();
        for (ObjectMessage objectMessage : objectMessages) {
            jsonArray.add((JsonElement)JsonSerializationKt.toJsonObject(objectMessage));
        }
        return jsonArray;
    }
}

