/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.ErrorCode;
import io.ably.lib.objects.HttpStatusCode;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a'\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\b\u0010\u0018\u001a\u00020\u0003H\u0000\"\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"ablyException", "Lio/ably/lib/types/AblyException;", "errorMessage", "", "errorCode", "Lio/ably/lib/objects/ErrorCode;", "statusCode", "Lio/ably/lib/objects/HttpStatusCode;", "cause", "", "errorInfo", "Lio/ably/lib/types/ErrorInfo;", "createErrorInfo", "createAblyException", "kotlin.jvm.PlatformType", "(Lio/ably/lib/types/ErrorInfo;Ljava/lang/Throwable;)Lio/ably/lib/types/AblyException;", "clientError", "serverError", "objectError", "invalidInputError", "byteSize", "", "getByteSize", "(Ljava/lang/String;)I", "generateNonce", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nio/ably/lib/objects/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n1557#3:120\n1628#3,3:121\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nio/ably/lib/objects/UtilsKt\n*L\n116#1:120\n116#1:121,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final AblyException ablyException(@NotNull String errorMessage, @NotNull ErrorCode errorCode, @NotNull HttpStatusCode statusCode, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        ErrorInfo errorInfo = UtilsKt.createErrorInfo(errorMessage, errorCode, statusCode);
        AblyException ablyException = UtilsKt.createAblyException(errorInfo, cause);
        Intrinsics.checkNotNullExpressionValue((Object)ablyException, (String)"createAblyException(...)");
        return ablyException;
    }

    public static /* synthetic */ AblyException ablyException$default(String string, ErrorCode errorCode, HttpStatusCode httpStatusCode, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            httpStatusCode = HttpStatusCode.BadRequest;
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        return UtilsKt.ablyException(string, errorCode, httpStatusCode, throwable);
    }

    @NotNull
    public static final AblyException ablyException(@NotNull ErrorInfo errorInfo, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)errorInfo, (String)"errorInfo");
        AblyException ablyException = UtilsKt.createAblyException(errorInfo, cause);
        Intrinsics.checkNotNullExpressionValue((Object)ablyException, (String)"createAblyException(...)");
        return ablyException;
    }

    public static /* synthetic */ AblyException ablyException$default(ErrorInfo errorInfo, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return UtilsKt.ablyException(errorInfo, throwable);
    }

    private static final ErrorInfo createErrorInfo(String errorMessage, ErrorCode errorCode, HttpStatusCode statusCode) {
        return new ErrorInfo(errorMessage, statusCode.getCode(), errorCode.getCode());
    }

    private static final AblyException createAblyException(ErrorInfo errorInfo, Throwable cause) {
        Throwable throwable;
        block3: {
            block2: {
                throwable = cause;
                if (throwable == null) break block2;
                Throwable it = throwable;
                boolean bl = false;
                AblyException ablyException = AblyException.fromErrorInfo((Throwable)it, (ErrorInfo)errorInfo);
                throwable = ablyException;
                if (ablyException != null) break block3;
            }
            throwable = AblyException.fromErrorInfo((ErrorInfo)errorInfo);
        }
        return throwable;
    }

    @NotNull
    public static final AblyException clientError(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return UtilsKt.ablyException$default(errorMessage, ErrorCode.BadRequest, HttpStatusCode.BadRequest, null, 8, null);
    }

    @NotNull
    public static final AblyException serverError(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return UtilsKt.ablyException$default(errorMessage, ErrorCode.InternalError, HttpStatusCode.InternalServerError, null, 8, null);
    }

    @NotNull
    public static final AblyException objectError(@NotNull String errorMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return UtilsKt.ablyException(errorMessage, ErrorCode.InvalidObject, HttpStatusCode.InternalServerError, cause);
    }

    public static /* synthetic */ AblyException objectError$default(String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return UtilsKt.objectError(string, throwable);
    }

    @NotNull
    public static final AblyException invalidInputError(@NotNull String errorMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return UtilsKt.ablyException(errorMessage, ErrorCode.InvalidInputParams, HttpStatusCode.InternalServerError, cause);
    }

    public static /* synthetic */ AblyException invalidInputError$default(String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return UtilsKt.invalidInputError(string, throwable);
    }

    public static final int getByteSize(@NotNull String $this$byteSize) {
        Intrinsics.checkNotNullParameter((Object)$this$byteSize, (String)"<this>");
        String string = $this$byteSize;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray.length;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateNonce() {
        void $this$mapTo$iv$iv;
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Iterable $this$map$iv = (Iterable)new IntRange(1, 16);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(StringsKt.random((CharSequence)chars, (Random)((Random)Random.Default))));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

