/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ably.lib.objects.HelpersKt;
import io.ably.lib.objects.ObjectData;
import io.ably.lib.objects.ObjectMessage;
import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectState;
import io.ably.lib.objects.ObjectValue;
import io.ably.lib.objects.ObjectsCounter;
import io.ably.lib.objects.ObjectsCounterOp;
import io.ably.lib.objects.ObjectsMap;
import io.ably.lib.objects.ObjectsMapEntry;
import io.ably.lib.objects.ObjectsMapOp;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.serialization.JsonSerializationKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0006H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0007H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\bH\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\tH\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\nH\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u000bH\u0002\u001a\u000e\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\nH\u0000\u00a8\u0006\u000e"}, d2={"size", "", "Lio/ably/lib/objects/ObjectMessage;", "Lio/ably/lib/objects/ObjectOperation;", "Lio/ably/lib/objects/ObjectState;", "Lio/ably/lib/objects/ObjectsMapOp;", "Lio/ably/lib/objects/ObjectsCounterOp;", "Lio/ably/lib/objects/ObjectsMap;", "Lio/ably/lib/objects/ObjectsCounter;", "Lio/ably/lib/objects/ObjectsMapEntry;", "Lio/ably/lib/objects/ObjectData;", "Lio/ably/lib/objects/ObjectValue;", "isInvalid", "", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nObjectMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectMessage.kt\nio/ably/lib/objects/ObjectMessageKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,460:1\n1#2:461\n*E\n"})
public final class ObjectMessageKt {
    public static final int size(@NotNull ObjectMessage $this$size) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        String string = $this$size.getClientId();
        int clientIdSize = string != null ? string.length() : 0;
        ObjectOperation objectOperation = $this$size.getOperation();
        int operationSize = objectOperation != null ? ObjectMessageKt.size(objectOperation) : 0;
        ObjectState objectState = $this$size.getObjectState();
        int objectStateSize = objectState != null ? ObjectMessageKt.size(objectState) : 0;
        JsonObject jsonObject = $this$size.getExtras();
        if (jsonObject != null) {
            JsonObject it = jsonObject;
            boolean bl = false;
            n = JsonSerializationKt.getGson().toJson((JsonElement)it).length();
        } else {
            n = 0;
        }
        int extrasSize = n;
        return clientIdSize + operationSize + objectStateSize + extrasSize;
    }

    private static final int size(ObjectOperation $this$size) {
        ObjectsMapOp objectsMapOp = $this$size.getMapOp();
        int mapOpSize = objectsMapOp != null ? ObjectMessageKt.size(objectsMapOp) : 0;
        ObjectsCounterOp objectsCounterOp = $this$size.getCounterOp();
        int counterOpSize = objectsCounterOp != null ? ObjectMessageKt.size(objectsCounterOp) : 0;
        ObjectsMap objectsMap = $this$size.getMap();
        int mapSize = objectsMap != null ? ObjectMessageKt.size(objectsMap) : 0;
        ObjectsCounter objectsCounter = $this$size.getCounter();
        int counterSize = objectsCounter != null ? ObjectMessageKt.size(objectsCounter) : 0;
        return mapOpSize + counterOpSize + mapSize + counterSize;
    }

    private static final int size(ObjectState $this$size) {
        ObjectsMap objectsMap = $this$size.getMap();
        int mapSize = objectsMap != null ? ObjectMessageKt.size(objectsMap) : 0;
        ObjectsCounter objectsCounter = $this$size.getCounter();
        int counterSize = objectsCounter != null ? ObjectMessageKt.size(objectsCounter) : 0;
        ObjectOperation objectOperation = $this$size.getCreateOp();
        int createOpSize = objectOperation != null ? ObjectMessageKt.size(objectOperation) : 0;
        return mapSize + counterSize + createOpSize;
    }

    private static final int size(ObjectsMapOp $this$size) {
        int keySize = $this$size.getKey().length();
        ObjectData objectData = $this$size.getData();
        int dataSize = objectData != null ? ObjectMessageKt.size(objectData) : 0;
        return keySize + dataSize;
    }

    private static final int size(ObjectsCounterOp $this$size) {
        return $this$size.getAmount() != null ? 8 : 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final int size(ObjectsMap $this$size) {
        int n;
        Map<String, ObjectsMapEntry> map = $this$size.getEntries();
        if (map != null && (map = map.entrySet()) != null) {
            Iterable iterable = (Iterable)((Object)map);
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                Map.Entry entry = (Map.Entry)t;
                int n3 = n2;
                boolean bl = false;
                int n4 = ((String)it.getKey()).length() + ObjectMessageKt.size((ObjectsMapEntry)it.getValue());
                n2 = n3 + n4;
            }
            n = n2;
        } else {
            n = 0;
        }
        int entriesSize = n;
        return entriesSize;
    }

    private static final int size(ObjectsCounter $this$size) {
        return $this$size.getCount() != null ? 8 : 0;
    }

    private static final int size(ObjectsMapEntry $this$size) {
        ObjectData objectData = $this$size.getData();
        return objectData != null ? ObjectMessageKt.size(objectData) : 0;
    }

    private static final int size(ObjectData $this$size) {
        ObjectValue objectValue = $this$size.getValue();
        return objectValue != null ? ObjectMessageKt.size(objectValue) : 0;
    }

    private static final int size(ObjectValue $this$size) {
        int n;
        ObjectValue objectValue = $this$size;
        if (objectValue instanceof ObjectValue.Boolean) {
            n = 1;
        } else if (objectValue instanceof ObjectValue.Binary) {
            n = HelpersKt.size(((ObjectValue.Binary)$this$size).getValue());
        } else if (objectValue instanceof ObjectValue.Number) {
            n = 8;
        } else if (objectValue instanceof ObjectValue.String) {
            n = UtilsKt.getByteSize(((ObjectValue.String)$this$size).getValue());
        } else if (objectValue instanceof ObjectValue.JsonObject || objectValue instanceof ObjectValue.JsonArray) {
            n = UtilsKt.getByteSize($this$size.getValue().toString());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInvalid(@Nullable ObjectData $this$isInvalid) {
        ObjectData objectData = $this$isInvalid;
        CharSequence charSequence = objectData != null ? objectData.getObjectId() : null;
        if (charSequence != null) {
            if (charSequence.length() != 0) return false;
        }
        boolean bl = true;
        if (!bl) return false;
        ObjectData objectData2 = $this$isInvalid;
        if (objectData2 == null) return true;
        ObjectValue objectValue = objectData2.getValue();
        if (objectValue != null) return false;
        return true;
    }
}

