/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.DefaultRealtimeObjects;
import io.ably.lib.objects.LiveObjectsPlugin;
import io.ably.lib.objects.ObjectsAdapter;
import io.ably.lib.objects.RealtimeObjects;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.types.ProtocolMessage;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/ably/lib/objects/DefaultLiveObjectsPlugin;", "Lio/ably/lib/objects/LiveObjectsPlugin;", "adapter", "Lio/ably/lib/objects/ObjectsAdapter;", "<init>", "(Lio/ably/lib/objects/ObjectsAdapter;)V", "objects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/ably/lib/objects/DefaultRealtimeObjects;", "getInstance", "Lio/ably/lib/objects/RealtimeObjects;", "channelName", "handle", "", "msg", "Lio/ably/lib/types/ProtocolMessage;", "handleStateChange", "state", "Lio/ably/lib/realtime/ChannelState;", "hasObjects", "", "dispose", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nDefaultLiveObjectsPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLiveObjectsPlugin.kt\nio/ably/lib/objects/DefaultLiveObjectsPlugin\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n72#2,2:37\n1#3:39\n1863#4,2:40\n*S KotlinDebug\n*F\n+ 1 DefaultLiveObjectsPlugin.kt\nio/ably/lib/objects/DefaultLiveObjectsPlugin\n*L\n12#1:37,2\n12#1:39\n30#1:40,2\n*E\n"})
public final class DefaultLiveObjectsPlugin
implements LiveObjectsPlugin {
    @NotNull
    private final ObjectsAdapter adapter;
    @NotNull
    private final ConcurrentHashMap<String, DefaultRealtimeObjects> objects;

    public DefaultLiveObjectsPlugin(@NotNull ObjectsAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.adapter = adapter;
        this.objects = new ConcurrentHashMap();
    }

    @NotNull
    public RealtimeObjects getInstance(@NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        ConcurrentMap $this$getOrPut$iv = this.objects;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(channelName);
        if (object == null) {
            boolean bl = false;
            DefaultRealtimeObjects default$iv = new DefaultRealtimeObjects(channelName, this.adapter);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(channelName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (RealtimeObjects)object;
    }

    public void handle(@NotNull ProtocolMessage msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            String channelName = msg.channel;
            DefaultRealtimeObjects defaultRealtimeObjects = this.objects.get(channelName);
            if (defaultRealtimeObjects == null) break block0;
            defaultRealtimeObjects.handle$liveobjects(msg);
        }
    }

    public void handleStateChange(@NotNull String channelName, @NotNull ChannelState state, boolean hasObjects) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            DefaultRealtimeObjects defaultRealtimeObjects = this.objects.get(channelName);
            if (defaultRealtimeObjects == null) break block0;
            defaultRealtimeObjects.handleStateChange$liveobjects(state, hasObjects);
        }
    }

    public void dispose(@NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        DefaultRealtimeObjects defaultRealtimeObjects = this.objects.remove(channelName);
        if (defaultRealtimeObjects != null) {
            defaultRealtimeObjects.dispose(UtilsKt.clientError("Channel has been released using channels.release()"));
        }
    }

    public void dispose() {
        Collection<DefaultRealtimeObjects> collection = this.objects.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DefaultRealtimeObjects it = (DefaultRealtimeObjects)element$iv;
            boolean bl = false;
            it.dispose(UtilsKt.clientError("AblyClient has been closed using client.close()"));
        }
        this.objects.clear();
    }
}

