/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.util;

import com.infusers.core.secrets.dto.OtherSecrets;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class InfusersUtility {
    private static InfusersUtility instance;
    private boolean isEmailConfigrued = false;
    private Logger log = LogManager.getLogger(InfusersUtility.class);

    public boolean isEmailConfigrued() {
        return this.isEmailConfigrued;
    }

    public void setEmailConfigrued(boolean isEmailConfigrued) {
        this.isEmailConfigrued = isEmailConfigrued;
    }

    public static final InfusersUtility getInstance() {
        if (instance == null) {
            instance = new InfusersUtility();
        }
        return instance;
    }

    public String getActiveProfile(Environment environment) {
        String[] activeProfiles;
        String[] stringArray = activeProfiles = environment != null ? environment.getActiveProfiles() : null;
        if (activeProfiles != null && activeProfiles.length > 0) {
            return activeProfiles[0];
        }
        this.log.error("InfusersUtility.getActiveProfile() No active profiles!, " + activeProfiles);
        return null;
    }

    public boolean isActiveProfileDevelopment(Environment environment) {
        return environment != null && this.isActiveProfileDevelopment(this.getActiveProfile(environment));
    }

    public boolean isActiveProfileDevelopment(String activeProfile) {
        return activeProfile != null && activeProfile.contains("dev");
    }

    public String getToken(String email) {
        return Jwts.builder().issuedAt(new Date()).expiration(new Date(System.currentTimeMillis() + (long)((int)(OtherSecrets.getInstance().getJwtTokenExpiryHoursNumber() * 60.0 * 60.0 * 1000.0)))).claim("name", (Object)email).claim("email", (Object)email).subject(email).issuer("infusers.in").signWith(this.getSigningKey()).compact();
    }

    private Key getSigningKey() {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)OtherSecrets.getInstance().getJwttokensecret());
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }

    public String getUser(String token) {
        if (token != null && token.trim().length() > 0) {
            String jwtToken = token.replace("Bearer", "").trim();
            try {
                Jws claimsJws = Jwts.parser().setSigningKey(this.getSigningKey()).build().parseClaimsJws((CharSequence)jwtToken);
                return ((Claims)claimsJws.getPayload()).getSubject();
            }
            catch (Exception e) {
                this.log.error("InfusersUtility.getUser() :: exception. " + e.getMessage() + " :: token = " + token + " :: jwtToken = " + jwtToken);
            }
        }
        return null;
    }

    public Long parseString2Long(String stringVal) {
        return stringVal == null ? 0L : Long.parseLong(stringVal.trim());
    }

    public String getLoggedInUserName() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            Object pricipal = auth.getPrincipal();
            if (pricipal != null) {
                return (String)pricipal;
            }
            this.log.error("InfusersUtility.getLoggedInUserName() Principal is NULL, " + pricipal);
            return null;
        }
        this.log.error("InfusersUtility.getLoggedInUserName() Authentication is NULL, " + auth);
        return null;
    }
}

