/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.user.remote;

import com.infusers.core.user.dto.UserDetailsDto;
import com.infusers.core.util.InfusersUtility;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteUserService {
    final Logger log = LogManager.getLogger(RemoteUserService.class);
    @Value(value="${infusers.auth.getuser.endpoint}")
    private String userEndpoint;
    @Value(value="${infusers.auth.url}")
    private String infusersAuthUrl;
    @Value(value="${myapp.rom.request.mapping}")
    private String requestMapping;
    @Value(value="${infusers.token.inter.api.communication}")
    private String infuserTokenInterApiCommunication;

    public UserDetailsDto getUser(String userName) {
        return this.getUserRemote(userName);
    }

    private UserDetailsDto getUserRemote(String userName) {
        this.log.debug("RemoteUserService.getUserRemote() :: user name : " + userName);
        if (userName == null || userName.trim().length() < 1) {
            this.log.error("RemoteUserService.getUserRemote() :: User Name is empty/invalid. user name : " + userName);
            return null;
        }
        String urlString = this.infusersAuthUrl + this.requestMapping + this.userEndpoint + userName;
        String endpoint = "";
        try {
            URL url = new URL(urlString);
            endpoint = url.toString();
            String bearerToken = InfusersUtility.getInstance().getToken(userName);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.setBearerAuth(bearerToken);
            requestHeaders.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)requestHeaders);
            ResponseEntity userDto = restTemplate.exchange(endpoint, HttpMethod.GET, requestEntity, UserDetailsDto.class, new Object[0]);
            return (UserDetailsDto)userDto.getBody();
        }
        catch (Exception e) {
            this.log.error("RemoteUserService.getUserRemote()" + e.getMessage() + " urlString = " + urlString + " :: endpoint = " + endpoint);
            return null;
        }
    }
}

