/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.user.dto;

import com.infusers.core.user.APIUser;
import java.io.Serializable;
import java.util.Date;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;

@RedisHash(value="UserDetailsDto")
public final class UserDetailsDto
extends JdkSerializationRedisSerializer
implements Serializable {
    private static final long serialVersionUID = 443911446941799444L;
    private long id;
    private String username;
    private String password;
    private String firstname;
    private String lastname;
    private String mobilenumber;
    private String countrycode;
    private boolean admin;
    private boolean active;
    private String verificationCode;
    private Date createdAt;

    public String getCountrycode() {
        return this.countrycode;
    }

    public void setCountrycode(String countrycode) {
        this.countrycode = countrycode;
    }

    public String getMobilenumber() {
        return this.mobilenumber;
    }

    public void setMobilenumber(String mobilenumber) {
        this.mobilenumber = mobilenumber;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstName) {
        this.firstname = firstName;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastName) {
        this.lastname = lastName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean isadmin) {
        this.admin = isadmin;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isactive) {
        this.active = isactive;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void copy(APIUser apiUser) {
        if (apiUser != null) {
            this.id = apiUser.getId();
            this.username = apiUser.getUsername();
            this.password = apiUser.getPassword();
            this.firstname = apiUser.getFirstname();
            this.lastname = apiUser.getLastname();
            this.mobilenumber = String.valueOf(apiUser.getMobilenumber());
            this.countrycode = apiUser.getCountrycode();
            this.admin = apiUser.isAdmin();
            this.active = apiUser.isActive();
            this.verificationCode = apiUser.getVerificationCode();
            this.createdAt = apiUser.getCreatedAt();
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isValid() {
        return this.username != null && this.username.length() != 0 && this.password != null && this.password.length() != 0;
    }

    public int hashCode() {
        return this.username != null ? this.username.hashCode() : -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UserDetailsDto userDetails = (UserDetailsDto)obj;
        return userDetails.username.equals(this.username);
    }
}

