/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.springdoc;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringdocConfig {
    private static final String SCHEME_NAME_BASIC = "basicAuth";
    private static final String SCHEME_BASIC = "basic";
    private static final String SCHEME_NAME_JWT = "Bearer Authentication";
    private static final String SCHEME_JWT = "bearer";

    @Bean
    public OpenAPI customOpenAPI() {
        return new OpenAPI().components(new Components().addSecuritySchemes(SCHEME_NAME_JWT, this.createJWTSecurityScheme())).addSecurityItem(new SecurityRequirement().addList(SCHEME_NAME_JWT));
    }

    private SecurityScheme createBasicSecurityScheme() {
        return new SecurityScheme().name(SCHEME_NAME_BASIC).type(SecurityScheme.Type.HTTP).scheme(SCHEME_BASIC);
    }

    private SecurityScheme createJWTSecurityScheme() {
        return new SecurityScheme().name(SCHEME_NAME_JWT).type(SecurityScheme.Type.HTTP).scheme(SCHEME_JWT);
    }
}

