/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.security.common;

import com.infusers.core.security.common.AuthenticationFilter;
import com.infusers.core.security.common.AuthorizationFilter;
import com.infusers.core.security.common.InfusersAuthenticationEntryPoint;
import jakarta.servlet.Filter;
import java.util.Arrays;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class WebSecurityConfiguration {
    private final AuthenticationConfiguration authenticationConfiguration;
    private final ApplicationContext applicationContext;
    private static final String[] AUTH_WHITELIST = new String[]{"/v2/api-docs", "/api/v2/api-docs", "/swagger-resources", "/swagger-resources/**", "/configuration/ui", "/configuration/security", "/v3/api-docs/**", "/v3/api-docs/", "/v3/api-docs", "/swagger-ui/**", "/swagger-ui/", "/swagger-ui", "/swagger-ui.html", "/infusers/ws/hello", "/infusers/ws/topic/greetings", "/ws", "/ws/**", "/h2-console", "/infusers/user/login/social", "/oauth2/**", "/verify/**", "/infusers/user/verify", "/api/auth/**", "/infusers/api/version", "/infusers/quotes/**", "/infusers/platform/**", "/infusers/api/cloud-provider", "/actuator/**", "/actuator/", "/actuator", "/infusers/api/audit-spring-boot-dependencies", "/infusers/eng/insight-3p-lib", "/infusers/eng/insight-pom-file", "/infusers/user/signup", "/webjars/**"};

    public WebSecurityConfiguration(AuthenticationConfiguration authenticationConfiguration, ApplicationContext ctx) {
        this.authenticationConfiguration = authenticationConfiguration;
        this.applicationContext = ctx;
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        ((HttpSecurity)((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)httpSecurity.cors().and()).csrf().disable()).authorizeHttpRequests().requestMatchers((RequestMatcher[])Arrays.stream(AUTH_WHITELIST).map(AntPathRequestMatcher::new).toArray(AntPathRequestMatcher[]::new))).permitAll().anyRequest()).authenticated().and()).addFilter((Filter)new AuthenticationFilter(this.authenticationManager(this.authenticationConfiguration), this.applicationContext)).addFilter((Filter)new AuthorizationFilter(this.authenticationManager(this.authenticationConfiguration))).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new InfusersAuthenticationEntryPoint());
        return (SecurityFilterChain)httpSecurity.build();
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authConfiguration) throws Exception {
        return authConfiguration.getAuthenticationManager();
    }
}

