/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.security.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.infusers.core.audit.AuditService;
import com.infusers.core.user.dto.UserCredDto;
import com.infusers.core.user.dto.UserDetailsDto;
import com.infusers.core.user.remote.RemoteUserService;
import com.infusers.core.util.InfusersUtility;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class AuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    @Autowired(required=true)
    private AuditService auditService;
    @Autowired(required=true)
    private RemoteUserService userService;
    private String activeProfile;
    private Logger log = LogManager.getLogger(AuthenticationFilter.class);

    public AuthenticationFilter(ApplicationContext ctx) {
        this.initAppContext(ctx);
        this.setFilterProcessesUrl("/infusers/user/login");
    }

    public AuthenticationFilter(AuthenticationManager authenticationManager, ApplicationContext ctx) {
        super(authenticationManager);
        this.initAppContext(ctx);
        this.setFilterProcessesUrl("/infusers/user/login");
    }

    private void initAppContext(ApplicationContext ctx) {
        this.auditService = (AuditService)ctx.getBean(AuditService.class);
        this.userService = (RemoteUserService)ctx.getBean(RemoteUserService.class);
        this.activeProfile = ctx.getEnvironment().getActiveProfiles()[0];
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String userName = null;
        String password = null;
        UserDetailsDto userDto = null;
        try {
            UserCredDto creds = (UserCredDto)new ObjectMapper().readValue((InputStream)request.getInputStream(), UserCredDto.class);
            if (creds != null) {
                userName = creds.getUsername();
                password = creds.getPassword();
            }
            if (this.auditService != null) {
                this.auditService.logAudit(userName, "AuthFilter", "", "attemptAuthentication", "Entry");
            } else {
                this.log.error("AuthenticationFilter.attemptAuthentication() auditService is null. " + userName);
            }
            if (this.userService != null) {
                userDto = this.userService.getUser(userName);
                if (userDto != null) {
                    if (!(userDto.isActive() || this.activeProfile != null && this.activeProfile.contains("dev"))) {
                        this.log.error("AuthenticationFilter.attemptAuthentication() user is NOT active! " + userName + " :: " + userDto.isActive() + " :: " + userDto.getVerificationCode() + " :: activeProfile = " + this.activeProfile);
                        return null;
                    }
                    return this.getAuthenticationManager().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)userName, (Object)password, new ArrayList()));
                }
            } else {
                this.log.error("AuthenticationFilter.attemptAuthentication() userService is null. ", (Object)userName);
            }
        }
        catch (IOException e) {
            this.log.error("AuthenticationFilter.attemptAuthentication() Exception for the user: " + userName + " :: e = " + e.getMessage());
        }
        this.log.error("AuthenticationFilter.attemptAuthentication() -> Authentication failed for the user: " + userName + " :: userDto = " + userDto);
        throw new BadCredentialsException("Invalid Credentials!!");
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Authentication authentication) {
        if (this.auditService != null) {
            this.auditService.logAudit(((User)authentication.getPrincipal()).getUsername(), "AuthFilter", "", "successfulAuthentication", "Successful login");
        } else {
            this.log.error("AuthenticationFilter.successfulAuthentication() auditService is null. ", (Object)((User)authentication.getPrincipal()).getUsername());
        }
        String token = InfusersUtility.getInstance().getToken(((User)authentication.getPrincipal()).getUsername());
        response.addHeader("Authorization", "Bearer " + token);
        response.addHeader("Access-Control-Expose-Headers", "Authorization");
        response.setStatus(200);
        response.setContentType("application/json");
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("status", "success");
        responseMap.put("data", token);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonText = objectMapper.writeValueAsString(responseMap);
            response.getOutputStream().write(jsonText.getBytes());
        }
        catch (Exception e) {
            this.log.error("AuthenticationFilter.successfulAuthentication() Exception for the user: " + authentication.getName() + " :: e = " + e.getMessage());
        }
    }
}

