/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets.gcp;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.infusers.core.secrets.SecretManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class GCPSecretManager
implements SecretManager {
    private Logger log = LogManager.getLogger(GCPSecretManager.class);
    @Value(value="${infusers.secretsmanager.gcp.projectdetails}")
    private String gcpProjectDetails;

    @Bean
    public SecretManagerServiceClient secretManagerServiceClient() throws IOException {
        try {
            SecretManagerServiceClient client = SecretManagerServiceClient.create();
            return client;
        }
        catch (IOException e) {
            this.log.error("GCPSecretManager.secretManagerServiceClient()-> Failed to create SecretManagerServiceClient, looks like this is NOT GCP environment?" + e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean isCloudEnvironment() {
        return true;
    }

    @Override
    public String getSecret(String region, String secretName) {
        String secretFullName = this.gcpProjectDetails + secretName;
        try {
            SecretManagerServiceClient secretManagerServiceClient = this.secretManagerServiceClient();
            if (secretManagerServiceClient == null) {
                this.log.error("GCPSecretManager.getSecret()-> SecretManagerServiceClient is NULL, looks like this is NOT GCP environment?");
                return null;
            }
            SecretVersionName secretVersionName = SecretVersionName.of((String)"540509425443", (String)secretName, (String)"latest");
            AccessSecretVersionResponse response = secretManagerServiceClient.accessSecretVersion(secretVersionName);
            this.log.warn("GCPSecretManager.getSecret() :: FOUND!! secretName = " + secretName + " :: secretVersionName = " + secretVersionName);
            return response.getPayload().getData().toStringUtf8();
        }
        catch (Exception e) {
            this.log.error("GCPSecretManager.getSecret()" + e.getMessage() + " :: secretName = " + secretName);
            return null;
        }
    }

    @PreDestroy
    public void shutdown() {
        try {
            SecretManagerServiceClient client = this.secretManagerServiceClient();
            client.shutdown();
            try {
                client.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.log.error("GCPSecretManager.shutdown() InterruptedException : " + e.getMessage());
            }
        }
        catch (IOException e) {
            this.log.error("GCPSecretManager.shutdown() IOException : " + e.getMessage());
        }
    }
}

