/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets.az;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import com.google.gson.JsonObject;
import com.infusers.core.secrets.SecretManager;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AzSecretManager
implements SecretManager {
    private Logger log = LogManager.getLogger(AzSecretManager.class);

    @Override
    public boolean isCloudEnvironment() {
        return true;
    }

    @Override
    public String getSecret(String region, String secretName) {
        String keyVaultUrl = null;
        try {
            keyVaultUrl = "https://" + secretName + ".vault.azure.net/";
            SecretClient secretClient = new SecretClientBuilder().vaultUrl(keyVaultUrl).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildClient();
            List<SecretProperties> secretProperties = secretClient.listPropertiesOfSecrets().stream().collect(Collectors.toList());
            this.log.warn("AzSecretManager.getGCPSecret() :: FOUND!! secretName = " + secretName + " :: keyVaultUrl = " + keyVaultUrl);
            return AzSecretManager.convertToJSON(secretProperties, secretClient);
        }
        catch (Exception e) {
            this.log.error("AzSecretManager.getGCPSecret()" + e.getMessage() + " :: secretName = " + secretName + " :: keyVaultUrl = " + keyVaultUrl);
            return null;
        }
    }

    private static String convertToJSON(List<SecretProperties> secretPropertiesList, SecretClient secretClient) {
        JsonObject jsonObject = new JsonObject();
        for (SecretProperties secretProperties : secretPropertiesList) {
            String name = secretProperties.getName();
            String value = secretClient.getSecret(name).getValue();
            jsonObject.addProperty(name, value);
        }
        return jsonObject.toString();
    }
}

