/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.infusers.core.secrets.SecretManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AWSSecretManager
implements SecretManager {
    private Logger log = LogManager.getLogger(AWSSecretManager.class);

    @Override
    public boolean isCloudEnvironment() {
        return true;
    }

    @Override
    public String getSecret(String region, String secretName) {
        if (region == null || region.trim().length() == 0 || secretName == null || secretName.trim().length() == 0) {
            this.log.warn("AwsSecretsUtility.getSecret() region/secretName are empty/null.");
            return null;
        }
        try {
            AWSSecretsManager client = (AWSSecretsManager)((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false))).build();
            GetSecretValueRequest request = new GetSecretValueRequest().withSecretId(secretName);
            GetSecretValueResult result = client.getSecretValue(request);
            if (result.getSecretString() != null) {
                return result.getSecretString();
            }
            return new String(result.getSecretBinary().array());
        }
        catch (Exception e) {
            this.log.error("AwsSecretsUtility.getSecret()" + e.getMessage());
            return null;
        }
    }
}

