/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets;

import com.google.gson.Gson;
import com.infusers.core.logger.ILogger;
import com.infusers.core.secrets.SecretManager;
import com.infusers.core.secrets.dto.EmailSecrets;
import com.infusers.core.secrets.dto.OtherSecrets;
import com.infusers.core.secrets.dto.RabbitMQSecrets;
import com.infusers.core.util.InfusersUtility;
import java.util.Properties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SecretsLoader {
    private ILogger log = new ILogger(SecretsLoader.class);
    String emailSecretName = "infusers-email-configuration";
    String otherSecretName = "infusers-others";
    public static final String PROPERTY_NAME_EMAIL_PASSWORD = "spring.mail.password";
    public static final String PROPERTY_NAME_EMAIL_USER_NAME = "spring.mail.username";
    public static final String PROPERTY_NAME_EMAIL_HOST = "spring.mail.host";
    public static final String PROPERTY_NAME_EMAIL_PORT = "spring.mail.port";
    private static final String RABBIT_MQ_SECRET_NAME = "infusers-prod-rabbitmq";
    private static final String PROPERTY_NAME_RABBIT_MQ_HOST = "spring.rabbitmq.host";
    private static final String PROPERTY_NAME_RABBIT_MQ_PORT = "spring.rabbitmq.port";
    private static final String PROPERTY_NAME_RABBIT_MQ_USER_NAME = "spring.rabbitmq.username";
    private static final String PROPERTY_NAME_RABBIT_MQ_PASSWORD = "spring.rabbitmq.password";
    private SecretManager secretManager;
    private ConfigurableEnvironment configEnvironment;

    public SecretsLoader(SecretManager secretManager, ConfigurableEnvironment configEnvironment) {
        this.secretManager = secretManager;
        this.configEnvironment = configEnvironment;
        this.loadSecrets();
    }

    private void loadSecrets() {
        try {
            this.log.warnWithSeparator("SecretsLoader.loadSecrets() isCloudEnvironment() = " + this.secretManager.isCloudEnvironment());
            if (this.secretManager.isCloudEnvironment()) {
                this.log.warnWithSeparator("SecretsLoader.loadSecrets() :: This is Cloud Environment/Profile, about to load secrets!!");
                if (this.secretManager == null) {
                    this.log.errorWithSeparator("SecretsLoader.loadSecrets() :: Something is seriously wrong. STOP STOP STOP!! Secrets Manager is NULL..");
                    throw new RuntimeException("SecretsLoader.loadSecrets() :: Something is seriously wrong. STOP STOP STOP!! Secrets Manager is NULL..");
                }
                this.loadEmailConfiguration();
                this.loadOtherConfiguration();
                this.loadRabbitMQConfiguration();
            } else {
                this.log.warnWithSeparator("SecretsLoader.loadSecrets() :: Email's NOT configured, Active Prfile is NOT a Cloud Enviornment/Profile!!");
            }
        }
        catch (Exception e) {
            this.log.errorWithSeparator("SecretsLoader.loadSecrets() :: Error loading secrets." + e.getMessage());
        }
    }

    private void loadOtherConfiguration() {
        Gson gson = new Gson();
        String secretsStr = this.secretManager.getSecret("us-east-1", this.otherSecretName);
        OtherSecrets secrets = (OtherSecrets)gson.fromJson(secretsStr, OtherSecrets.class);
        if (secrets == null) {
            this.log.errorWithSeparator("SecretsLoader.loadOtherConfiguration() :: OtherSecrets are NOT available.");
            throw new RuntimeException("Others secrets are NULL, needs attention!!");
        }
        this.log.warn("SecretsLoader.loadOtherConfiguration() :: OtherSecrets are available.");
        double expiryHours = Double.parseDouble(secrets.getJwtTokenExpiryHours());
        OtherSecrets.getInstance().setJwttokensecret(secrets.getJwttokensecret());
        OtherSecrets.getInstance().setJwtTokenExpiryHoursNumber(expiryHours);
    }

    private void loadEmailConfiguration() {
        Gson gson = new Gson();
        String secretsStr = this.secretManager.getSecret("us-east-1", this.emailSecretName);
        EmailSecrets secrets = (EmailSecrets)gson.fromJson(secretsStr, EmailSecrets.class);
        if (secrets == null) {
            this.log.errorWithSeparator("SecretsLoader.loadEmailConfiguration() :: EmailSecrets are NOT available. Emails won't work!!");
            return;
        }
        this.log.warn("SecretsLoader.loadEmailConfiguration() :: EmailSecrets are available. Host = " + secrets.getHost() + " :: Port = " + secrets.getPort());
        Properties props = new Properties();
        props.put(PROPERTY_NAME_EMAIL_PASSWORD, secrets.getPassword());
        props.put(PROPERTY_NAME_EMAIL_HOST, secrets.getHost());
        props.put(PROPERTY_NAME_EMAIL_PORT, secrets.getPort());
        props.put(PROPERTY_NAME_EMAIL_USER_NAME, secrets.getUsername());
        this.configEnvironment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("aws.secret.manager", props));
        InfusersUtility.getInstance().setEmailConfigrued(true);
    }

    private void loadRabbitMQConfiguration() {
        try {
            String secretsStr = this.secretManager.getSecret("us-east-1", RABBIT_MQ_SECRET_NAME);
            Gson gson = new Gson();
            RabbitMQSecrets secrets = (RabbitMQSecrets)gson.fromJson(secretsStr, RabbitMQSecrets.class);
            if (secrets != null) {
                this.log.warnWithSeparator("SecretsLoader.loadRabbitMQConfiguration() :: RabbitMQSecrets are available");
                String host = secrets.getHost();
                String port = secrets.getPort();
                Properties props = new Properties();
                props.put(PROPERTY_NAME_RABBIT_MQ_PASSWORD, secrets.getPassword());
                props.put(PROPERTY_NAME_RABBIT_MQ_USER_NAME, secrets.getUsername());
                if (host != null && port != null && host.trim().length() > 0 && port.trim().length() > 0) {
                    this.log.warnWithSeparator("SecretsLoader.loadRabbitMQConfiguration() :: RabbitMQSecrets Host/Port details also available. host = " + host + " :: port = " + port);
                    props.put(PROPERTY_NAME_RABBIT_MQ_HOST, secrets.getHost());
                    props.put(PROPERTY_NAME_RABBIT_MQ_PORT, secrets.getPort());
                }
                this.configEnvironment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("aws.secret.manager", props));
            } else {
                this.log.errorWithSeparator("SecretsLoader.loadRabbitMQConfiguration() :: RabbitMQSecrets are NULL, Its okay if you don't have RabbitMQ installed, otherwise, needs attention!!");
            }
        }
        catch (Exception e) {
            this.log.error("SecretsLoader.loadRabbitMQConfiguration() :: Exception while loading RabbitMQ secretsL. " + e.getMessage());
        }
    }
}

