/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets;

import com.infusers.core.logger.ILogger;
import com.infusers.core.secrets.SecretManager;
import com.infusers.core.secrets.aws.AWSSecretManager;
import com.infusers.core.secrets.az.AzSecretManager;
import com.infusers.core.secrets.gcp.GCPSecretManager;
import com.infusers.core.secrets.local.DefaultSecretManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class SecretManagerConfig {
    private ILogger log = new ILogger(SecretManagerConfig.class);

    @Bean
    @Profile(value={"aws"})
    public SecretManager awsSecretManager() {
        this.log.warnWithSeparator("SecretManagerConfig.awsSecretManager()--> Profile is AWS!");
        return new AWSSecretManager();
    }

    @Bean
    @Profile(value={"gcp"})
    public SecretManager gcpSecretManager() {
        this.log.warnWithSeparator("SecretManagerConfig.gcpSecretManager()--> Profile is GCP!");
        return new GCPSecretManager();
    }

    @Bean
    @Profile(value={"az"})
    public SecretManager azSecretManager() {
        this.log.warnWithSeparator("SecretManagerConfig.azSecretManager()--> Profile is Az!");
        return new AzSecretManager();
    }

    @Bean
    @Profile(value={"!aws && !gcp && !az"})
    public SecretManager defaultSecretManager() {
        this.log.warnWithSeparator("SecretManagerConfig.defaultSecretManager()--> Profile is Local/Laptop!");
        return new DefaultSecretManager();
    }
}

