/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets;

import com.google.gson.Gson;
import com.infusers.core.logger.ILogger;
import com.infusers.core.secrets.SecretManager;
import com.infusers.core.secrets.SecretsLoader;
import com.infusers.core.secrets.dto.DBSecrets;
import com.infusers.core.secrets.dto.OtherSecrets;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;

@Configuration
public class AppConfig {
    @Value(value="${spring.secretsmanager.db.details}")
    String secretNameDB;
    @Value(value="${spring.aws.secretsmanager.region}")
    String region;
    @Value(value="${spring.datasource.url}")
    String url;
    @Value(value="${spring.datasource.username}")
    String userName;
    @Value(value="${spring.datasource.password}")
    String password;
    private ILogger log = new ILogger(AppConfig.class);
    @Autowired
    private SecretManager secretManager;
    @Autowired
    private ConfigurableEnvironment configEnvironment;

    public String getSecretValue(String region, String secretName) {
        return this.secretManager.getSecret(region, secretName);
    }

    @Bean
    public DataSource dataSource() {
        this.log.warnWithSeparator("AppConfig.dataSource() isCloudEnvironment() = {}", this.secretManager.isCloudEnvironment());
        DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
        if (this.secretManager.isCloudEnvironment()) {
            new SecretsLoader(this.secretManager, this.configEnvironment);
            DBSecrets secrets = this.getDBSecrets();
            if (secrets != null) {
                dataSourceBuilder.url("jdbc:" + secrets.getEngine() + "://" + secrets.getHost() + ":" + secrets.getPort() + "/" + secrets.getDbname()).username(secrets.getUsername()).password(secrets.getPassword()).build();
            } else {
                this.log.errorWithSeparator("AppConfig.dataSource() --> It is cloud environment, but secrets are NOT available. Something is NOT right here, needs attention!!");
            }
        } else {
            this.log.warnWithSeparator("AppConfig.dataSource() Not a cloud environment, falling back to Inmemory DB.");
            OtherSecrets.getInstance().setJwttokensecret("NoMoreASecretBuddyNoMoreASecretBuddyNoMoreASecretBuddyNoMoreASecretBuddyNoMoreASecretBuddy");
            OtherSecrets.getInstance().setJwtTokenExpiryHoursNumber(2.0);
            dataSourceBuilder.url(this.url).username(this.userName).password(this.password).build();
        }
        try {
            return dataSourceBuilder.build();
        }
        catch (DataSourceLookupFailureException e) {
            this.log.errorWithSeparator("AppConfig.dataSource() --> Exception while creating DB connection. Something is NOT right here, needs attention!!" + e.getMessage());
            throw new RuntimeException("Failed to create DataSource", e);
        }
    }

    private DBSecrets getDBSecrets() {
        String secretsStr = this.secretManager.getSecret(this.region, this.secretNameDB);
        Gson gson = new Gson();
        return (DBSecrets)gson.fromJson(secretsStr, DBSecrets.class);
    }
}

