/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.search;

import com.infusers.core.search.ISpecificationModel;
import com.infusers.core.search.SpecificationConfigElement;
import com.infusers.core.search.util.SpecificationUtility;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;

public abstract class AbsractSpecification {
    private String userName;
    private String searchString;
    private String userNameKey;

    public AbsractSpecification(String userName, String searchString, String userNameKey) {
        this.userName = userName;
        this.searchString = searchString;
        this.userNameKey = userNameKey;
    }

    protected String getUserNameFieldName() {
        return this.userNameKey;
    }

    protected String getUserName() {
        return this.userName;
    }

    public String getSearchString() {
        return this.searchString;
    }

    protected abstract List<SpecificationConfigElement> getConfigElements();

    public Specification getSpec() {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            String likeSearchString = SpecificationUtility.getSearchLikeString(this.searchString);
            ArrayList<Predicate> predicateListOr = new ArrayList<Predicate>();
            Predicate predicateUserNameUserAccess = null;
            if (this.userName != null && !this.userName.isEmpty()) {
                predicateUserNameUserAccess = criteriaBuilder.equal((Expression)root.get(this.userNameKey), (Object)this.userName);
            }
            List<SpecificationConfigElement> configElements = this.getConfigElements();
            int count = configElements.size();
            for (int i = 0; i < count; ++i) {
                SpecificationConfigElement element = configElements.get(i);
                predicateListOr.add(SpecificationUtility.createPredicate((Root<ISpecificationModel>)root, criteriaBuilder, element, this.searchString, likeSearchString));
            }
            Predicate predicateSearch = SpecificationUtility.joinPredicateMultipleOr(criteriaBuilder, predicateListOr);
            Predicate predicateFinal = SpecificationUtility.joinPredicatesAnd(criteriaBuilder, predicateSearch, predicateUserNameUserAccess);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (predicateFinal != null) {
                predicates.add(predicateFinal);
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }
}

