/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.logger;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ILogger {
    private final Logger logger;

    public ILogger(Class<?> clazz) {
        this.logger = LogManager.getLogger(clazz);
    }

    public void log(LogTypes type, String message) {
        switch (type) {
            case INFO: {
                this.info(message);
                break;
            }
            case DEBUG: {
                this.debug(message);
                break;
            }
            case WARN: {
                this.warn(message);
                break;
            }
            default: {
                this.errorWithSeparator("Unknown log type, update ILogger's log(LogTypes) to include this type = " + type + " Message to log :: " + message);
            }
        }
    }

    public void logSeparator() {
        this.logger.info("**********************************************************************");
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void warn(String message) {
        this.logger.warn(message);
    }

    public void warnWithSeparator(String message) {
        this.logSeparator();
        this.warn(message);
        this.logSeparator();
    }

    public void warnWithSeparator(String message, boolean b) {
        this.logSeparator();
        this.warn(message, b);
        this.logSeparator();
    }

    public void warn(String message, boolean b) {
        this.logger.warn(message, (Object)b);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void errorWithSeparator(String message) {
        this.logSeparator();
        this.error(message);
        this.logSeparator();
    }

    public static enum LogTypes {
        INFO,
        DEBUG,
        WARN,
        WARN_SEP,
        ERROR,
        ERROR_SEP;

    }
}

