/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.eng.selfheal.insights.pom.spring;

import com.infusers.core.eng.selfheal.insights.pom.dto.ArtifactDependencyInsightDto;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.boot.SpringBootVersion;

public class VersionDependencyAnalyzer {
    private static VersionDependencyAnalyzer instance;
    private static final String CLASS_NAME = "VersionDependencyAnalyzer";
    public static final String NO_PARENT = "Infuser";
    final Logger log = LogManager.getLogger(VersionDependencyAnalyzer.class);

    private VersionDependencyAnalyzer() {
    }

    public static VersionDependencyAnalyzer getInstance() {
        if (instance == null) {
            instance = new VersionDependencyAnalyzer();
        }
        return instance;
    }

    public String getSpringBootVersion() {
        ArtifactDependencyInsightDto dependencyDto = new ArtifactDependencyInsightDto("org.springframework.boot", "spring-boot-starter-parent", NO_PARENT);
        String springBootVer = SpringBootVersion.getVersion();
        dependencyDto.fillLatestVersionV2();
        String latestSpringBootVer = dependencyDto.getLatestVersion();
        latestSpringBootVer = latestSpringBootVer != null ? latestSpringBootVer.trim() : latestSpringBootVer;
        StringBuffer response = new StringBuffer();
        if (springBootVer != null && springBootVer.trim().equalsIgnoreCase(latestSpringBootVer)) {
            response.append(springBootVer);
        } else {
            response.append(springBootVer + ", Upgrade option: " + latestSpringBootVer);
        }
        return response.toString();
    }

    public String getDependencyVersion(String groupId, String artifactId) {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader("pom.xml"));
            for (Dependency dependency : model.getDependencies()) {
                if (!dependency.getGroupId().equals(groupId) || !dependency.getArtifactId().equals(artifactId)) continue;
                return dependency.getVersion();
            }
        }
        catch (FileNotFoundException e) {
            return "Looks like not supported in this environment??";
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

