/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.eng.selfheal.insights.pom.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.infusers.core.eng.selfheal.insights.pom.dto.ArtifactDependencyInsightDto;
import com.infusers.core.eng.selfheal.insights.pom.dto.GroupDependencyInsightDto;
import com.infusers.core.eng.selfheal.insights.pom.spring.Spring3PInsightKey;
import com.infusers.core.eng.selfheal.insights.pom.spring.Spring3PInsightKeyDuplicate;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class EngPOMInsightDTO
implements Serializable {
    @JsonIgnore
    final Logger log = LogManager.getLogger(EngPOMInsightDTO.class);
    private static final String CLASS_NAME = "EngPOMInsightDTO";
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private FileReader pomFileReader;
    private boolean recursive;
    private HashMap<String, GroupDependencyInsightDto> groupIdMap = new HashMap();
    private ArtifactDependencyInsightDto parent;
    @JsonIgnore
    private HashMap<Spring3PInsightKey, ArtifactDependencyInsightDto> insightProcessedMap = new HashMap();
    @JsonIgnore
    private HashMap<Spring3PInsightKeyDuplicate, ArtifactDependencyInsightDto> insightProcessedMapDuplicate = new HashMap();

    public EngPOMInsightDTO(boolean recursive, String groupId, String artifactId, String version) {
        this.recursive = recursive;
        this.parent = new ArtifactDependencyInsightDto(groupId, artifactId, "Infuser");
    }

    public EngPOMInsightDTO(boolean recursive, String groupId, String artifactId, String version, FileReader pomFileReader) {
        this.recursive = recursive;
        this.pomFileReader = pomFileReader;
        this.parent = new ArtifactDependencyInsightDto(groupId, artifactId, "Infuser");
    }

    public ArtifactDependencyInsightDto getParent() {
        return this.parent;
    }

    private List<GroupDependencyInsightDto> getInsightsList() {
        return new ArrayList<GroupDependencyInsightDto>(this.groupIdMap.values());
    }

    public List<GroupDependencyInsightDto> sort() {
        List<GroupDependencyInsightDto> insightsList = this.getInsightsList();
        Collections.sort(insightsList);
        return insightsList;
    }

    public void processInsightForGivenPOMFile() throws XmlPullParserException, IOException {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)this.pomFileReader);
            this.auditSpringBootDependencies(model);
        }
        catch (IOException e) {
            this.log.error(String.format("EngPOMInsightDTO.processInsightForGivenPOMFile() IOException :: %s", e.getMessage()));
            throw e;
        }
        catch (XmlPullParserException ex) {
            this.log.error(String.format("EngPOMInsightDTO.processInsightForGivenPOMFile() XmlPullParserException :: %s", ex.getMessage()));
            throw ex;
        }
    }

    @JsonIgnore
    public String toString() {
        return "EngPOMInsightDTO [recursive=" + this.recursive + ", groupIdMap=" + this.groupIdMap + ", parent=" + this.parent + "]";
    }

    public void getInsightForGiven3PLib() throws IOException, XmlPullParserException {
        String version = this.getParent().getVersion();
        if (version == null || version.trim().length() == 0) {
            this.getParent().fillLatestVersionV2();
            version = this.getParent().getLatestVersion();
            this.getParent().setVersion(version);
        }
        this.getParent().fillInsightForGiven3PLib(this);
        this.getParent().appendNotes("Insights provided for the version: " + version);
    }

    public void auditSpringBootDependencies(Model model) {
        try {
            for (Dependency dependency : model.getDependencies()) {
                Spring3PInsightKeyDuplicate dupKey = new Spring3PInsightKeyDuplicate(dependency, model);
                if (this.insightProcessedMapDuplicate.containsKey(dupKey)) continue;
                String groupId = dependency.getGroupId();
                GroupDependencyInsightDto groupDto = this.groupIdMap.get(groupId);
                if (groupDto == null) {
                    groupDto = new GroupDependencyInsightDto(groupId);
                    this.groupIdMap.put(groupId, groupDto);
                }
                ArtifactDependencyInsightDto artifactDto = groupDto.addArtifact(dependency, model);
                this.insightProcessedMapDuplicate.put(dupKey, artifactDto);
                Spring3PInsightKey key = new Spring3PInsightKey(dependency);
                ArtifactDependencyInsightDto insightDone = this.insightProcessedMap.get(key);
                if (insightDone == null) {
                    this.insightProcessedMap.put(key, artifactDto);
                    artifactDto.auditADependency(model);
                    if (!artifactDto.isValid3P() || !this.recursive) continue;
                    artifactDto.fillInsightForGiven3PLib(this);
                    continue;
                }
                artifactDto.copy(insightDone);
            }
        }
        catch (Exception e) {
            this.log.error("EngPOMInsightDTO.auditSpringBootDependencies(Model) Exception :: " + e.getMessage());
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public FileReader getPomFileReader() {
        return this.pomFileReader;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public HashMap<String, GroupDependencyInsightDto> getGroupIdMap() {
        return this.groupIdMap;
    }

    public HashMap<Spring3PInsightKey, ArtifactDependencyInsightDto> getInsightProcessedMap() {
        return this.insightProcessedMap;
    }

    public HashMap<Spring3PInsightKeyDuplicate, ArtifactDependencyInsightDto> getInsightProcessedMapDuplicate() {
        return this.insightProcessedMapDuplicate;
    }

    @JsonIgnore
    public void setPomFileReader(FileReader pomFileReader) {
        this.pomFileReader = pomFileReader;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setGroupIdMap(HashMap<String, GroupDependencyInsightDto> groupIdMap) {
        this.groupIdMap = groupIdMap;
    }

    public void setParent(ArtifactDependencyInsightDto parent) {
        this.parent = parent;
    }

    @JsonIgnore
    public void setInsightProcessedMap(HashMap<Spring3PInsightKey, ArtifactDependencyInsightDto> insightProcessedMap) {
        this.insightProcessedMap = insightProcessedMap;
    }

    @JsonIgnore
    public void setInsightProcessedMapDuplicate(HashMap<Spring3PInsightKeyDuplicate, ArtifactDependencyInsightDto> insightProcessedMapDuplicate) {
        this.insightProcessedMapDuplicate = insightProcessedMapDuplicate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngPOMInsightDTO)) {
            return false;
        }
        EngPOMInsightDTO other = (EngPOMInsightDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRecursive() != other.isRecursive()) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        FileReader this$pomFileReader = this.getPomFileReader();
        FileReader other$pomFileReader = other.getPomFileReader();
        if (this$pomFileReader == null ? other$pomFileReader != null : !this$pomFileReader.equals(other$pomFileReader)) {
            return false;
        }
        HashMap<String, GroupDependencyInsightDto> this$groupIdMap = this.getGroupIdMap();
        HashMap<String, GroupDependencyInsightDto> other$groupIdMap = other.getGroupIdMap();
        if (this$groupIdMap == null ? other$groupIdMap != null : !((Object)this$groupIdMap).equals(other$groupIdMap)) {
            return false;
        }
        ArtifactDependencyInsightDto this$parent = this.getParent();
        ArtifactDependencyInsightDto other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        HashMap<Spring3PInsightKey, ArtifactDependencyInsightDto> this$insightProcessedMap = this.getInsightProcessedMap();
        HashMap<Spring3PInsightKey, ArtifactDependencyInsightDto> other$insightProcessedMap = other.getInsightProcessedMap();
        if (this$insightProcessedMap == null ? other$insightProcessedMap != null : !((Object)this$insightProcessedMap).equals(other$insightProcessedMap)) {
            return false;
        }
        HashMap<Spring3PInsightKeyDuplicate, ArtifactDependencyInsightDto> this$insightProcessedMapDuplicate = this.getInsightProcessedMapDuplicate();
        HashMap<Spring3PInsightKeyDuplicate, ArtifactDependencyInsightDto> other$insightProcessedMapDuplicate = other.getInsightProcessedMapDuplicate();
        return !(this$insightProcessedMapDuplicate == null ? other$insightProcessedMapDuplicate != null : !((Object)this$insightProcessedMapDuplicate).equals(other$insightProcessedMapDuplicate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngPOMInsightDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRecursive() ? 79 : 97);
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        FileReader $pomFileReader = this.getPomFileReader();
        result = result * 59 + ($pomFileReader == null ? 43 : $pomFileReader.hashCode());
        HashMap<String, GroupDependencyInsightDto> $groupIdMap = this.getGroupIdMap();
        result = result * 59 + ($groupIdMap == null ? 43 : ((Object)$groupIdMap).hashCode());
        ArtifactDependencyInsightDto $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        HashMap<Spring3PInsightKey, ArtifactDependencyInsightDto> $insightProcessedMap = this.getInsightProcessedMap();
        result = result * 59 + ($insightProcessedMap == null ? 43 : ((Object)$insightProcessedMap).hashCode());
        HashMap<Spring3PInsightKeyDuplicate, ArtifactDependencyInsightDto> $insightProcessedMapDuplicate = this.getInsightProcessedMapDuplicate();
        result = result * 59 + ($insightProcessedMapDuplicate == null ? 43 : ((Object)$insightProcessedMapDuplicate).hashCode());
        return result;
    }

    public EngPOMInsightDTO() {
    }
}

