/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.eng.selfheal.insights.pom.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.infusers.core.eng.selfheal.insights.pom.dto.EngPOMInsightDTO;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ArtifactDependencyInsightDto
implements Serializable,
Comparable<ArtifactDependencyInsightDto> {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    final Logger log = LogManager.getLogger(ArtifactDependencyInsightDto.class);
    private static final String CLASS_NAME = "ArtifactDependencyInsightDto";
    private String groupId;
    private String artifactId;
    private String version;
    private String latestVersion;
    private String notes = "";
    private String url;
    private boolean needsAttention;
    private String parentArtifactId;

    public ArtifactDependencyInsightDto(String groupId, String artifactId, String parentArtifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.parentArtifactId = parentArtifactId;
    }

    public ArtifactDependencyInsightDto(Dependency dependency, String parentArtifactId) {
        this.groupId = dependency.getGroupId();
        this.artifactId = dependency.getArtifactId();
        this.version = dependency.getVersion();
        this.parentArtifactId = parentArtifactId;
    }

    public String toString() {
        return "ArtifactDependencyInsightDto{groupId='" + this.groupId + "', artifactId=" + this.artifactId + ", version='" + this.version + "', latestVersion='" + this.latestVersion + "', notes='" + this.notes + "', url='" + this.url + "', needsAttention='" + this.needsAttention + "', parentArtifactId='" + this.parentArtifactId + "'}";
    }

    public void copy(ArtifactDependencyInsightDto insightDone) {
        this.latestVersion = insightDone.getLatestVersion();
        this.notes = insightDone.getNotes();
        this.url = insightDone.url;
        this.needsAttention = insightDone.isNeedsAttention();
    }

    @Override
    public int compareTo(ArtifactDependencyInsightDto dependencyDto) {
        return Boolean.compare(dependencyDto.isNeedsAttention(), this.needsAttention);
    }

    @JsonIgnore
    public boolean isValid3P() {
        return this.groupId != null && this.groupId.trim().length() > 0 && !this.groupId.contains("${") && this.artifactId != null && this.artifactId.trim().length() > 0 && !this.artifactId.contains("${");
    }

    @JsonIgnore
    public boolean isValidVersion() {
        return this.version != null && this.version.trim().length() > 0 && !this.version.contains("${");
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void appendNotes(String notes) {
        this.notes = this.notes + " :: " + notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public boolean isNeedsAttention() {
        return this.needsAttention;
    }

    public void setNeedsAttention(boolean needsAttention) {
        this.needsAttention = needsAttention;
    }

    public void fillInsightForGiven3PLib(EngPOMInsightDTO pomInsight) throws IOException, XmlPullParserException {
        try {
            if (!this.isValid3P()) {
                return;
            }
            String version = this.getVersion();
            if (version == null || version.contains("${")) {
                return;
            }
            String pomUrl = String.format("https://repo1.maven.org/maven2/%s/%s/%s/%s-%s.pom", this.getGroupId().replace('.', '/'), this.getArtifactId(), version, this.getArtifactId(), version);
            try (InputStream inputStream = new URL(pomUrl).openStream();){
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model model = reader.read(inputStream);
                pomInsight.auditSpringBootDependencies(model);
            }
        }
        catch (IOException e) {
            this.log.error(String.format("ArtifactDependencyInsightDto.fillInsightForGiven3PLib() IOException :: %s", e.getMessage()));
            this.appendNotes(e.getMessage());
            this.setNeedsAttention(true);
        }
        catch (XmlPullParserException ex) {
            this.log.error(String.format("ArtifactDependencyInsightDto.fillInsightForGiven3PLib() XmlPullParserException :: %s", ex.getMessage()));
            this.appendNotes(ex.getMessage());
            this.setNeedsAttention(true);
        }
    }

    public void auditADependency(Model model) {
        try {
            this.fillLatestVersionV2();
            if (!this.isValid3P()) {
                this.setNeedsAttention(true);
                this.appendNotes("Not a valid Dependency!!");
                return;
            }
            String version = this.getVersion();
            String string = version = version != null ? version.trim() : version;
            if (version != null && version.contains("${")) {
                String versionFromProperties;
                version = version.substring(2, version.length() - 1);
                String string2 = versionFromProperties = model != null ? model.getProperties().getProperty(version) : null;
                if (versionFromProperties != null) {
                    this.setVersion(version);
                    version = versionFromProperties;
                }
                if (version == null || version.contains("${")) {
                    this.setNeedsAttention(true);
                    this.appendNotes("Invalid version!! " + version);
                    return;
                }
            }
            if (this.isNeedsAttention()) {
                return;
            }
            if (version == null || version.length() == 0) {
                this.appendNotes("Version NOT mentioned in the POM file!!");
                this.setNeedsAttention(false);
                return;
            }
            String latestVersion = this.getLatestVersion();
            String string3 = latestVersion = latestVersion != null ? latestVersion.trim() : latestVersion;
            if (latestVersion == null || latestVersion.length() == 0) {
                this.appendNotes("Latest version is null, something NOT right??");
                this.setNeedsAttention(true);
                return;
            }
            if (version != null && latestVersion != null) {
                boolean matching = version.trim().equalsIgnoreCase(latestVersion.trim());
                this.setNeedsAttention(!matching);
                if (!matching) {
                    this.appendNotes("Versions are NOT matching!!");
                } else {
                    this.appendNotes("");
                }
            } else {
                this.setNeedsAttention(true);
                this.appendNotes("Both the versions are null!!");
            }
        }
        catch (Exception e) {
            String auditingIssue = "Exception while auding the Dependency/Artifact :: Group Id = " + this.getGroupId() + " :: Artifact Id = " + this.getArtifactId() + " :: version = " + this.getVersion() + " :: latestVersion = " + this.getLatestVersion() + " :: Notes = " + this.getNotes();
            this.appendNotes(auditingIssue);
            this.log.error("ArtifactDependencyInsightDto.auditADependency(Model, DependencyDto) Exception while auding the Dependency/Artifact :: " + auditingIssue + ":: exception details : " + e.getMessage());
        }
    }

    public void fillLatestVersionV2() {
        if (!this.isValid3P()) {
            this.setNeedsAttention(true);
            this.appendNotes("Not a valid 3P!!");
            return;
        }
        try {
            String metadataUrl = String.format("https://repo1.maven.org/maven2/%s/%s/maven-metadata.xml", this.getGroupId().replaceAll("\\.", "/"), this.getArtifactId());
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            Metadata metadata = reader.read(new URL(metadataUrl).openStream());
            List versions = metadata.getVersioning().getVersions();
            String latestVerion = versions.stream().max(new VersionComparator()).orElse(null);
            if (latestVerion != null) {
                latestVerion = latestVerion.trim();
            }
            this.setLatestVersion(latestVerion);
            this.setUrl(metadataUrl);
        }
        catch (FileNotFoundException e) {
            this.log.error("ArtifactDependencyInsightDto.getLatestVersionV2() FileNotFoundException:: " + this.toString() + " :: " + e.getMessage());
            this.appendNotes("Dependency/Artifact not found!! " + this.toString());
            this.setNeedsAttention(true);
        }
        catch (Exception e) {
            this.log.error("ArtifactDependencyInsightDto.fillLatestVersionV2() Exception:: " + this.toString() + " :: " + e.getMessage());
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public String getUrl() {
        return this.url;
    }

    public String getParentArtifactId() {
        return this.parentArtifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setParentArtifactId(String parentArtifactId) {
        this.parentArtifactId = parentArtifactId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactDependencyInsightDto)) {
            return false;
        }
        ArtifactDependencyInsightDto other = (ArtifactDependencyInsightDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNeedsAttention() != other.isNeedsAttention()) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$latestVersion = this.getLatestVersion();
        String other$latestVersion = other.getLatestVersion();
        if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$parentArtifactId = this.getParentArtifactId();
        String other$parentArtifactId = other.getParentArtifactId();
        return !(this$parentArtifactId == null ? other$parentArtifactId != null : !this$parentArtifactId.equals(other$parentArtifactId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArtifactDependencyInsightDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNeedsAttention() ? 79 : 97);
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $latestVersion = this.getLatestVersion();
        result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $parentArtifactId = this.getParentArtifactId();
        result = result * 59 + ($parentArtifactId == null ? 43 : $parentArtifactId.hashCode());
        return result;
    }

    public ArtifactDependencyInsightDto() {
    }

    public class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String v1, String v2) {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String[] parts1 = v1.split("[.-]");
            String[] parts2 = v2.split("[.-]");
            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; ++i) {
                if (parts1[i].matches("\\d+") && parts2[i].matches("\\d+")) {
                    int part2;
                    int part1 = Integer.parseInt(parts1[i]);
                    if (part1 < (part2 = Integer.parseInt(parts2[i]))) {
                        return -1;
                    }
                    if (part1 <= part2) continue;
                    return 1;
                }
                int comparisonResult = parts1[i].compareTo(parts2[i]);
                if (comparisonResult == 0) continue;
                return comparisonResult;
            }
            return Integer.compare(parts1.length, parts2.length);
        }
    }
}

