/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.eng.selfheal.deployment;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CloudProviderService {
    private final Environment environment;
    private static final String CLASS_NAME = "CloudProviderService";
    final Logger log = LogManager.getLogger(CloudProviderService.class);

    @Autowired
    public CloudProviderService(Environment environment) {
        this.environment = environment;
    }

    public ResponseEntity<Object> getCloudProvider() {
        this.log.debug("CloudProviderService.getCloudProvider() Fetching deployment host detail.");
        StringBuffer cloudProviderInfo = new StringBuffer();
        cloudProviderInfo.append(this.getCloudProviderName());
        HashMap<String, CharSequence> response = new HashMap<String, CharSequence>();
        response.put("status", "success");
        response.put("data", cloudProviderInfo);
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.OK);
    }

    public String getCloudProviderName() {
        String[] activeProfiles;
        this.log.debug("CloudProviderService.getCloudProviderName() Fetching deployment host detail.");
        String cloudName = "Unknown Cloud Provider/Local Laptop";
        for (String profile : activeProfiles = this.environment.getActiveProfiles()) {
            if ("aws".equalsIgnoreCase(profile)) {
                cloudName = "Amazon Web Services (AWS)";
                break;
            }
            if ("gcp".equalsIgnoreCase(profile)) {
                cloudName = "Google Cloud Platform (GCP)";
                break;
            }
            if (!"az".equalsIgnoreCase(profile)) continue;
            cloudName = "Microsoft Azure";
            break;
        }
        return cloudName;
    }
}

