/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.eng.selfheal;

import com.infusers.core.eng.selfheal.deployment.CloudProviderService;
import com.infusers.core.eng.selfheal.insights.pom.dto.ArtifactDependencyInsightDto;
import com.infusers.core.eng.selfheal.insights.pom.dto.EngPOMInsightDTO;
import com.infusers.core.eng.selfheal.insights.pom.spring.VersionDependencyAnalyzer;
import com.infusers.core.eng.selfhealversion.java.InfusersJavaVersionDetails;
import java.io.FileReader;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class InfusersSelfHealService {
    private static final String CLASS_NAME = "InfusersSelfHealService";
    @Autowired(required=true)
    private CloudProviderService cloudProviderService;
    private ArtifactDependencyInsightDto infuserLibDependencyDto;
    final Logger log = LogManager.getLogger(InfusersSelfHealService.class);
    @Value(value="${infusers.app.name}")
    private String appName;
    @Value(value="${api.version.info}")
    private String versionInfo;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String PREFIX = " -- ";

    public InfusersSelfHealService() {
        this.init();
    }

    private void init() {
        this.infuserLibDependencyDto = new ArtifactDependencyInsightDto("in.infusers.library", "infusers-library", "Infuser");
        String presentVersion = VersionDependencyAnalyzer.getInstance().getDependencyVersion(this.infuserLibDependencyDto.getGroupId(), this.infuserLibDependencyDto.getArtifactId());
        presentVersion = presentVersion != null ? presentVersion.trim() : presentVersion;
        this.infuserLibDependencyDto.setVersion(presentVersion);
        this.infuserLibDependencyDto.fillLatestVersionV2();
    }

    public ResponseEntity<Object> getVersion() {
        this.log.debug("InfusersSelfHealService.getVersion() Fetching version details :: ", (Object)this.versionInfo);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "success");
        response.put("data", this.getVersionInformation());
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.OK);
    }

    private String getVersionInformation() {
        StringBuilder versionInfoSummary = new StringBuilder();
        versionInfoSummary.append(String.format("%s:  %s", this.appName, this.versionInfo));
        versionInfoSummary.append(String.format("%sInfuser's Lib: %s", LINE_SEPARATOR, this.getInfusersLibraryUpgradeOption()));
        versionInfoSummary.append(String.format("%sJava: %s", LINE_SEPARATOR, InfusersJavaVersionDetails.getInstance().getJavaVersion()));
        versionInfoSummary.append(String.format("%sSpring Boot: %s", LINE_SEPARATOR, VersionDependencyAnalyzer.getInstance().getSpringBootVersion()));
        versionInfoSummary.append(String.format("%sHosted on:", LINE_SEPARATOR));
        versionInfoSummary.append(String.format("%s%s%s", LINE_SEPARATOR, PREFIX, this.cloudProviderService.getCloudProviderName()));
        versionInfoSummary.append(String.format("%s%s%s", LINE_SEPARATOR, PREFIX, this.getOSDetails()));
        return versionInfoSummary.toString();
    }

    private String getOSDetails() {
        String os = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        StringBuffer osInfoSummary = new StringBuffer();
        osInfoSummary.append("OS details: ");
        osInfoSummary.append(os);
        osInfoSummary.append(", " + osVersion);
        osInfoSummary.append(", " + osArch);
        return osInfoSummary.toString();
    }

    private String getInfusersLibraryUpgradeOption() {
        String presentVersion = this.infuserLibDependencyDto.getVersion();
        String latestVer = this.infuserLibDependencyDto.getLatestVersion();
        StringBuffer response = new StringBuffer();
        if (presentVersion != null && presentVersion.equalsIgnoreCase(latestVer)) {
            response.append(presentVersion);
        } else {
            response.append(presentVersion + ", Upgrade option: " + latestVer);
        }
        return response.toString();
    }

    public ResponseEntity<Object> auditSpringBootDependencies(boolean recursive) {
        try {
            EngPOMInsightDTO pomInsight = new EngPOMInsightDTO(recursive, null, null, null, new FileReader("pom.xml"));
            pomInsight.processInsightForGivenPOMFile();
            pomInsight.getInsightForGiven3PLib();
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(pomInsight.sort());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)("Not able to process Insights!! Exception message = " + e.getMessage()));
        }
    }
}

