/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.eng.selfheal;

import com.infusers.core.eng.selfheal.InfusersSelfHealService;
import com.infusers.core.eng.selfheal.deployment.CloudProviderService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"infusers/api"})
@CrossOrigin(origins={"*"})
public class InfusersSelfHealController {
    @Autowired(required=true)
    private InfusersSelfHealService apiService;
    @Autowired(required=true)
    private CloudProviderService cloudProviderService;
    private Logger log = LogManager.getLogger(InfusersSelfHealController.class);

    @GetMapping(value={"/cloud-provider"})
    public ResponseEntity<Object> getCloudProvider() {
        return this.cloudProviderService.getCloudProvider();
    }

    @GetMapping(value={"/version"})
    public ResponseEntity<Object> getVersion() {
        this.log.debug("InfusersSelfHealController.getVersion() Fetching version details ");
        return this.apiService.getVersion();
    }

    @GetMapping(value={"/audit-spring-boot-dependencies"})
    public ResponseEntity<Object> auditSpringBootDependencies(@RequestParam(defaultValue="false", required=false) boolean recursive) {
        return this.apiService.auditSpringBootDependencies(recursive);
    }
}

