/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.cache.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
@ConditionalOnProperty(name={"redis.hostname"})
public class RedisConfig {
    @Value(value="${redis.hostname}")
    private String redisHostName;
    @Value(value="${redis.port}")
    private int redisPort;
    @Value(value="${redis.prefix}")
    private String redisPrefix;
    private static final Duration expiration = Duration.ofMinutes(60L);

    @Bean(name={"jedisConnectionFactory"})
    JedisConnectionFactory jedisConnectionFactory() {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(this.redisHostName, this.redisPort);
        return new JedisConnectionFactory(redisStandaloneConfiguration);
    }

    @Bean(value={"redisTemplate"})
    public RedisTemplate<String, String> redisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration(this.redisHostName, this.redisPort);
        JedisClientConfiguration jedisClientConfiguration = JedisClientConfiguration.builder().build();
        JedisConnectionFactory factory = new JedisConnectionFactory(configuration, jedisClientConfiguration);
        factory.afterPropertiesSet();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)factory);
        return redisTemplate;
    }

    @Bean(name={"cacheManager"})
    public RedisCacheManager cacheManager(RedisConnectionFactory redisConnectionFactory, ResourceLoader resourceLoader, ObjectMapper objectMapper) {
        JdkSerializationRedisSerializer serializer = new JdkSerializationRedisSerializer(resourceLoader.getClassLoader());
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(CacheKeyPrefix.prefixed((String)this.redisPrefix)).entryTtl(expiration).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)serializer));
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(config).build();
    }
}

