/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.cache.redis;

import com.infusers.core.logger.ILogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"redis.hostname"})
public class InfuserCacheClearingComponent {
    private ILogger log = new ILogger(InfuserCacheClearingComponent.class);
    private final ApplicationContext applicationContext;

    @Autowired
    public InfuserCacheClearingComponent(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void clearCache() {
        String[] redisTemplateNames;
        for (String redisTemplateName : redisTemplateNames = this.applicationContext.getBeanNamesForType(RedisTemplate.class)) {
            RedisTemplate redisTemplate = (RedisTemplate)this.applicationContext.getBean(redisTemplateName, RedisTemplate.class);
            redisTemplate.getConnectionFactory().getConnection().flushDb();
        }
        this.log.warnWithSeparator("InfuserCacheClearingComponent.clearCache() --> Redis cache cleared on Startup/Shutdown/On New user created!!");
    }
}

