/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.audit.response;

import com.infusers.core.audit.AuditRecord;
import com.infusers.core.user.dto.UserDetailsDto;
import com.infusers.core.user.remote.RemoteUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;

public class AuditRecordsListDto
extends JdkSerializationRedisSerializer
implements Serializable {
    private transient RemoteUserService userService;
    final Logger log = LogManager.getLogger(AuditRecordsListDto.class);
    private static final String CLASS_NAME = "AuditService";
    private long total_count;
    private List<AuditRecord> items = new ArrayList<AuditRecord>();

    public List<AuditRecord> getItems() {
        return this.items;
    }

    public long getTotal_count() {
        return this.total_count;
    }

    public AuditRecordsListDto(RemoteUserService userService) {
        this.userService = userService;
    }

    public void copy(List<AuditRecord> colist, long totalcount) {
        this.total_count = totalcount;
        int count = colist != null ? colist.size() : 0;
        HashMap<String, UserDetailsDto> userMap = new HashMap<String, UserDetailsDto>();
        for (int i = 0; i < count; ++i) {
            AuditRecord auditRecord = colist.get(i);
            UserDetailsDto userDetails = (UserDetailsDto)userMap.get(auditRecord.getUserEmailId());
            if (userDetails == null) {
                userDetails = this.userService.getUser(auditRecord.getUserEmailId());
                if (userDetails == null) {
                    this.log.error("AuditRecordsListDto.copy() User NOT FOUND, so creating temp object. user email id = " + auditRecord.getUserEmailId());
                    userDetails = new UserDetailsDto();
                    userDetails.setFirstname("User NOT found!");
                    userDetails.setLastname("User NOT found!");
                    userDetails.setUsername(auditRecord.getUserEmailId());
                }
                userMap.put(auditRecord.getUserEmailId(), userDetails);
            }
            AuditRecord auditDto = new AuditRecord(auditRecord, userDetails);
            this.items.add(auditDto);
        }
    }
}

