/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.audit;

import com.infusers.core.audit.AuditRecord;
import com.infusers.core.audit.AuditRepository;
import com.infusers.core.audit.response.AuditRecordsListDto;
import com.infusers.core.audit.search.AuditSpecification;
import com.infusers.core.logger.ILogger;
import com.infusers.core.user.dto.UserDetailsDto;
import com.infusers.core.user.remote.RemoteUserService;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Service
public class AuditService {
    final Logger log = LogManager.getLogger(AuditService.class);
    private static final String CLASS_NAME = "AuditService";
    @Autowired(required=true)
    private AuditRepository auditRepository;
    @Autowired(required=true)
    private RemoteUserService userService;

    public AuditRecordsListDto getAllAuditRecords(Integer pageNo, Integer pageSize, String sortBy, String order, String searchString, String userName) {
        boolean searchActive;
        this.log.debug(String.format("AuditService.getAllAuditRecords() Fetching List of Audit Records on Pagination :: pageNo =%d  :: pageSize = %d :: sortBy = '%s' :: order = '%s' :: searchString = %s :: userName = %s", pageNo, pageSize, sortBy, order, searchString, userName));
        UserDetailsDto userDto = this.userService.getUser(userName);
        PageRequest paging = order.equalsIgnoreCase("asc") ? PageRequest.of((int)pageNo, (int)pageSize, (Sort)Sort.by((String[])new String[]{sortBy}).ascending()) : PageRequest.of((int)pageNo, (int)pageSize, (Sort)Sort.by((String[])new String[]{sortBy}).descending());
        Page<AuditRecord> pagedResult = null;
        boolean bl = searchActive = searchString != null && !searchString.isEmpty();
        if (searchActive) {
            AuditSpecification spec = null;
            spec = userDto != null && userDto.isAdmin() ? new AuditSpecification(null, searchString) : new AuditSpecification(userDto != null ? userDto.getUsername() : "", searchString);
            pagedResult = this.auditRepository.findAll((Specification<AuditRecord>)spec.getSpec(), (Pageable)paging);
        } else {
            pagedResult = userDto != null && userDto.isAdmin() ? this.auditRepository.findAll((Pageable)paging) : this.auditRepository.findByUserEmailId(userDto != null ? userDto.getUsername() : "", (Pageable)paging);
        }
        AuditRecordsListDto auditList = new AuditRecordsListDto(this.userService);
        if (pagedResult.hasContent()) {
            auditList.copy(pagedResult.getContent(), pagedResult.getTotalElements());
        }
        return auditList;
    }

    private ResponseEntity<Object> createAuditRecord(AuditRecord auditRecord) {
        this.log.debug("AuditService.createAuditRecord() Creating new audit record, audit id = ", (Object)auditRecord.getId());
        try {
            AuditRecord savedAuditRecord = (AuditRecord)this.auditRepository.save(auditRecord);
            URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{savedAuditRecord.getId()}).toUri();
            return ResponseEntity.created((URI)location).build();
        }
        catch (Exception e) {
            this.log.error("AuditService.createAuditRecord() Creating new audit record, audit id = ", (Object)(auditRecord.getId() + " :: error = " + e.getMessage()));
            return null;
        }
    }

    public boolean logAudit(String userEmailId, String entityName, String entityId, String action, String comments) {
        AuditRecord auditLog = new AuditRecord(userEmailId, entityName, entityId, action, comments);
        ResponseEntity<Object> createdLog = this.createAuditRecord(auditLog);
        return createdLog != null;
    }

    public boolean log(ILogger log, ILogger.LogTypes logType, String userEmailId, String entityName, String entityId, String action, String comments) {
        log.log(logType, comments);
        AuditRecord auditLog = new AuditRecord(userEmailId, entityName, entityId, action, comments);
        ResponseEntity<Object> createdLog = this.createAuditRecord(auditLog);
        return createdLog != null;
    }
}

