/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.audit;

import com.infusers.core.user.dto.UserDetailsDto;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.SequenceGenerator;
import java.io.Serializable;
import java.util.Date;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;

@Entity
public class AuditRecord
extends JdkSerializationRedisSerializer
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="INFUSERS")
    @SequenceGenerator(name="INFUSERS", sequenceName="AUDIT_SEQ", allocationSize=1)
    private Long id;
    private Date createdAt;
    private String userEmailId;
    private String entityName;
    private String entityId;
    private String action;
    private String comments;

    @PrePersist
    void createdAt() {
        this.createdAt = new Date();
    }

    private AuditRecord() {
        this.createdAt();
    }

    public AuditRecord(AuditRecord record, UserDetailsDto userDetails) {
        this.id = record.id;
        this.userEmailId = record.userEmailId;
        this.entityName = record.entityName;
        this.entityId = record.entityId;
        this.action = record.action;
        this.comments = record.comments;
        this.createdAt = record.createdAt;
    }

    public AuditRecord(String userEmailId, String entityName, String entityId, String action, String comments) {
        this.userEmailId = userEmailId;
        this.entityName = entityName;
        this.entityId = entityId;
        this.action = action;
        this.comments = comments;
        this.createdAt();
    }

    public Long getId() {
        return this.id;
    }

    public String getUserEmailId() {
        return this.userEmailId;
    }

    public void setUserEmailId(String userEmailId) {
        this.userEmailId = userEmailId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }
}

