/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.version.springboot;

import com.infusers.core.audit.AuditService;
import com.infusers.core.version.springboot.dto.DependencyDto;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootVersion;

public class InfusersSpringBootVersionDetails {
    private static InfusersSpringBootVersionDetails instance;
    private static final String CLASS_NAME = "InfusersSpringBootVersionDetails";
    @Autowired(required=true)
    private AuditService auditService;
    final Logger log = LogManager.getLogger(InfusersSpringBootVersionDetails.class);

    private InfusersSpringBootVersionDetails() {
    }

    public static InfusersSpringBootVersionDetails getInstance() {
        if (instance == null) {
            instance = new InfusersSpringBootVersionDetails();
        }
        return instance;
    }

    public String getSpringBootVersion() {
        DependencyDto dependencyDto = new DependencyDto("org.springframework.boot", "spring-boot-starter-parent", "", "", false, "");
        String latestSpringBootVer = this.getLatestVersionV2(dependencyDto);
        StringBuffer response = new StringBuffer();
        response.append(SpringBootVersion.getVersion() + " in use, latest available: " + latestSpringBootVer);
        return response.toString();
    }

    public String getDependencyVersion(String groupId, String artifactId) {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader("pom.xml"));
            for (Dependency dependency : model.getDependencies()) {
                if (!dependency.getGroupId().equals(groupId) || !dependency.getArtifactId().equals(artifactId)) continue;
                return dependency.getVersion();
            }
        }
        catch (FileNotFoundException e) {
            return "Looks like not supported in this environment??";
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public List<DependencyDto> auditSpringBootDependencies() {
        ArrayList<DependencyDto> list = new ArrayList<DependencyDto>();
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader("pom.xml"));
            for (Dependency dependency : model.getDependencies()) {
                DependencyDto dependencyDto = new DependencyDto(dependency);
                list.add(dependencyDto);
                this.auditADependency(dependencyDto);
            }
        }
        catch (Exception e) {
            this.log.error("InfusersSpringBootVersionDetails.getSpringBootDependenciesVersionDetails() Exception :: " + e.getMessage());
        }
        return list;
    }

    private void auditADependency(DependencyDto dependencyDto) {
        try {
            String latestVersion = this.getLatestVersionV2(dependencyDto);
            if (dependencyDto.isNeedsAttention()) {
                return;
            }
            String version = dependencyDto.getVersion();
            if (version == null || latestVersion == null) {
                dependencyDto.setNotes("One of the versions are null!");
                dependencyDto.setNeedsAttention(true);
                return;
            }
            if (version != null && latestVersion != null) {
                boolean matching = version.trim().equalsIgnoreCase(latestVersion.trim());
                dependencyDto.setNeedsAttention(!matching);
                if (!matching) {
                    dependencyDto.setNotes("Versions are NOT matching!!");
                } else {
                    dependencyDto.setNotes("");
                }
            } else {
                dependencyDto.setNeedsAttention(true);
                dependencyDto.setNotes("Both the versions are null!!");
            }
        }
        catch (Exception e) {
            String auditingIssue = "Exception while auding the Dependency/Artifact :: Group Id = " + dependencyDto.getGroupId() + " :: Artifact Id = " + dependencyDto.getArtifactId() + " :: version = " + dependencyDto.getVersion() + " :: latestVersion = " + dependencyDto.getLatestVersion() + " :: Notes = " + dependencyDto.getNotes();
            dependencyDto.setNotes(auditingIssue);
            this.log.error("InfusersSpringBootVersionDetails.auditADependency() Exception while auding the Dependency/Artifact :: " + auditingIssue + ":: exception details : " + e.getMessage());
        }
    }

    public String getLatestVersionV2(DependencyDto dependencyDto) {
        if (dependencyDto == null) {
            return null;
        }
        try {
            String metadataUrl = String.format("https://repo1.maven.org/maven2/%s/%s/maven-metadata.xml", dependencyDto.getGroupId().replaceAll("\\.", "/"), dependencyDto.getArtifactId());
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            Metadata metadata = reader.read(new URL(metadataUrl).openStream());
            List versions = metadata.getVersioning().getVersions();
            String latestVerion = versions.stream().max(Comparator.naturalOrder()).orElse(null);
            dependencyDto.setLatestVersion(latestVerion);
            return latestVerion;
        }
        catch (FileNotFoundException e) {
            this.log.info("InfusersSpringBootVersionDetails.getLatestVersionV2() FileNotFoundException:: groupId = " + dependencyDto.getGroupId() + " :: artifactId = " + dependencyDto.getArtifactId() + " :: " + e.getMessage());
            dependencyDto.setNotes("Dependency/Artifact not found!! groupId = " + dependencyDto.getGroupId() + " :: artifactId = " + dependencyDto.getArtifactId());
            dependencyDto.setNeedsAttention(true);
        }
        catch (Exception e) {
            this.log.error("InfusersSpringBootVersionDetails.getLatestVersionV2() Exception:: groupId = " + dependencyDto.getGroupId() + " :: artifactId = " + dependencyDto.getArtifactId() + " :: " + e.getMessage());
        }
        return null;
    }
}

