/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.version.java;

import com.infusers.core.audit.AuditService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

public class InfusersJavaVersionDetails {
    private static InfusersJavaVersionDetails instance;
    private static final String CLASS_NAME = "InfusersJavaVersionDetails";
    @Autowired(required=true)
    private AuditService auditService;
    final Logger log = LogManager.getLogger(InfusersJavaVersionDetails.class);

    private InfusersJavaVersionDetails() {
    }

    public static InfusersJavaVersionDetails getInstance() {
        if (instance == null) {
            instance = new InfusersJavaVersionDetails();
        }
        return instance;
    }

    public String getJavaVersion() {
        return System.getProperty("java.version") + " in use, latest available: " + this.getLatestJavaVersion();
    }

    public String getLatestJavaVersion() {
        String latestVersion = "";
        try {
            String url = "https://www.oracle.com/java/technologies/downloads/";
            Document doc = Jsoup.connect((String)url).get();
            Elements downloadLinks = doc.select("[href*='jdk'][href*='linux-aarch64_bin.tar.gz']");
            Element latestLink = downloadLinks.first();
            if (latestLink != null) {
                String archiveName = latestLink.attr("href");
                Path archivePath = Paths.get(archiveName, new String[0]);
                String regex = "^([^-]+-[^-]+)_.*\\.tar\\.gz$";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(archivePath.getFileName().toString());
                if (matcher.matches()) {
                    latestVersion = matcher.group(1);
                }
            }
        }
        catch (Exception e) {
            return "Some issue, found excpetion";
        }
        return latestVersion;
    }
}

