/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.version;

import com.infusers.core.audit.AuditRecord;
import com.infusers.core.audit.AuditService;
import com.infusers.core.version.java.InfusersJavaVersionDetails;
import com.infusers.core.version.springboot.InfusersSpringBootVersionDetails;
import com.infusers.core.version.springboot.dto.DependencyDto;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class APIService {
    private static final String CLASS_NAME = "APIService";
    @Autowired(required=true)
    private AuditService auditService;
    final Logger log = LogManager.getLogger(APIService.class);
    @Value(value="${infusers.app.name}")
    private String appName;
    @Value(value="${api.version.info}")
    private String versionInfo;

    public ResponseEntity<Object> getVersion() {
        this.auditService.createAuditRecord(new AuditRecord("Non protected API!", 3, CLASS_NAME, "getVersion()->Non protected API."));
        this.log.debug("APIService.getVersion() Fetching version details :: ", (Object)this.versionInfo);
        StringBuffer versionInfoSummary = new StringBuffer();
        versionInfoSummary.append(this.appName + ": " + this.versionInfo);
        versionInfoSummary.append(System.lineSeparator() + "Infuser's Lib: " + this.getInfusersLibraryVersion());
        versionInfoSummary.append(System.lineSeparator() + "Java: " + InfusersJavaVersionDetails.getInstance().getJavaVersion());
        versionInfoSummary.append(System.lineSeparator() + "Spring Boot: " + InfusersSpringBootVersionDetails.getInstance().getSpringBootVersion());
        HashMap<String, CharSequence> response = new HashMap<String, CharSequence>();
        response.put("status", "success");
        response.put("data", versionInfoSummary);
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.OK);
    }

    private String getInfusersLibraryVersion() {
        DependencyDto dependencyDto = new DependencyDto("in.infusers.library", "infusers-library", "", "", false, "");
        String presentVersion = InfusersSpringBootVersionDetails.getInstance().getDependencyVersion(dependencyDto.getGroupId(), dependencyDto.getArtifactId());
        String latestVer = InfusersSpringBootVersionDetails.getInstance().getLatestVersionV2(dependencyDto);
        StringBuffer response = new StringBuffer();
        response.append(presentVersion + " in use, latest available: " + latestVer);
        return response.toString();
    }

    public List<DependencyDto> auditSpringBootDependencies() {
        return InfusersSpringBootVersionDetails.getInstance().auditSpringBootDependencies();
    }
}

