/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.version;

import com.infusers.core.version.APIService;
import com.infusers.core.version.springboot.dto.DependencyDto;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"infusers/api"})
@CrossOrigin(origins={"*"})
public class APIController {
    @Autowired(required=true)
    private APIService apiService;
    private Logger log = LogManager.getLogger(APIController.class);

    @GetMapping(value={"/version"})
    public ResponseEntity<Object> getVersion() {
        this.log.debug("APIController.getVersion() Fetching version details ");
        return this.apiService.getVersion();
    }

    @GetMapping(value={"/audit-spring-boot-dependencies"})
    public ResponseEntity<List<DependencyDto>> auditSpringBootDependencies() {
        List<DependencyDto> list = this.apiService.auditSpringBootDependencies();
        return new ResponseEntity(list, (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }
}

