/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.util;

import com.infusers.core.secrets.dto.OtherSecrets;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class InfusersUtility {
    private static InfusersUtility instance;
    private final String jwtTokenSecret = "NoMoreASecretBuddy";
    private boolean isEmailConfigrued = false;
    private boolean isJWTTokenDynamicEnabled = false;
    private Logger log = LogManager.getLogger(InfusersUtility.class);

    public boolean isJWTTokenDynamicEnabled() {
        return this.isJWTTokenDynamicEnabled;
    }

    public void setJWTTokenDynamicEnabled(boolean isJWTTokenDynamicEnabled) {
        this.isJWTTokenDynamicEnabled = isJWTTokenDynamicEnabled;
    }

    public boolean isEmailConfigrued() {
        return this.isEmailConfigrued;
    }

    public void setEmailConfigrued(boolean isEmailConfigrued) {
        this.isEmailConfigrued = isEmailConfigrued;
    }

    public static final InfusersUtility getInstance() {
        if (instance == null) {
            instance = new InfusersUtility();
        }
        return instance;
    }

    public String getActiveProfile(Environment environment) {
        String[] activeProfiles;
        String[] stringArray = activeProfiles = environment != null ? environment.getActiveProfiles() : null;
        if (activeProfiles != null && activeProfiles.length > 0) {
            return activeProfiles[0];
        }
        this.log.error("InfusersUtility.getActiveProfile() No active profiles!, " + activeProfiles);
        return null;
    }

    public boolean isActiveProfileDevelopment(Environment environment) {
        return environment != null && this.isActiveProfileDevelopment(this.getActiveProfile(environment));
    }

    public boolean isActiveProfileDevelopment(String activeProfile) {
        return activeProfile != null && activeProfile.contains("dev");
    }

    public String getToken(String email) {
        return Jwts.builder().setSubject(String.format("%s", email)).setIssuer("infusers.in").setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + (long)((int)(OtherSecrets.getInstance().getJwtTokenExpiryHoursNumber() * 60.0 * 60.0 * 1000.0)))).signWith(SignatureAlgorithm.HS512, this.getJwttokensecret().getBytes()).compact();
    }

    public String getJwttokensecret() {
        if (this.isJWTTokenDynamicEnabled) {
            return OtherSecrets.getInstance().getJwttokensecret();
        }
        return "NoMoreASecretBuddy";
    }

    public Long parseString2Long(String stringVal) {
        return stringVal == null ? 0L : Long.parseLong(stringVal.trim());
    }

    public String getLoggedInUserName() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Object pricipal = auth.getPrincipal();
        if (pricipal != null) {
            return (String)pricipal;
        }
        this.log.error("InfusersUtility.getLoggedInUserName() Principal is NULL, " + pricipal);
        return null;
    }
}

