/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.user.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import java.io.Serializable;
import java.util.Date;

@Entity
public class APIUser
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    private Date createdAt;
    @Column(name="username", unique=true)
    private String username;
    @JsonIgnore
    @Column(name="password")
    private String password;
    @Column(name="firstname")
    private String firstname;
    @Column(name="lastname")
    private String lastname;
    @Column(name="admin")
    private boolean admin = false;
    @Column(name="active")
    private boolean active = true;
    @Column(name="provider")
    private String provider;
    @Column(name="mobilenumber")
    private Long mobilenumber;
    @Column(name="countrycode")
    private String countrycode;
    @Column(name="verification_code", length=64)
    private String verificationCode;

    @PrePersist
    void createdAt() {
        this.createdAt = new Date();
    }

    public APIUser() {
    }

    public APIUser(long id, String username, String password, String firstName, String lastName, boolean isAdmin, boolean isActive, String provider, String countrycode, Long mobilenumber, String verificationCode) {
        this.id = id;
        this.username = username;
        this.password = password;
        this.firstname = firstName;
        this.lastname = lastName;
        this.admin = isAdmin;
        this.active = isActive;
        this.provider = provider;
        this.countrycode = countrycode;
        this.mobilenumber = mobilenumber;
        this.verificationCode = verificationCode;
        this.createdAt();
    }

    public String getCountrycode() {
        return this.countrycode;
    }

    public void setCountrycode(String countrycode) {
        this.countrycode = countrycode;
    }

    public Long getMobilenumber() {
        return this.mobilenumber;
    }

    public void setMobilenumber(Long mobilenumber) {
        this.mobilenumber = mobilenumber;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean isAdmin) {
        this.admin = isAdmin;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstName) {
        this.firstname = firstName;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastName) {
        this.lastname = lastName;
    }

    public long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    @JsonProperty
    public void setPassword(String password) {
        this.password = password;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isValid() {
        return this.username != null && this.username.length() != 0 && (this.password != null && this.password.length() != 0 || this.provider != null && this.provider.trim().length() != 0) && this.firstname != null && this.firstname.length() != 0 && this.lastname != null && this.lastname.length() != 0;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public int hashCode() {
        return this.username != null ? this.username.hashCode() : -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        APIUser user = (APIUser)obj;
        return user.username.equals(this.username);
    }
}

