/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.security.common;

import com.infusers.core.util.InfusersUtility;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class AuthorizationFilter
extends BasicAuthenticationFilter {
    private Logger log = LogManager.getLogger(AuthorizationFilter.class);

    public AuthorizationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String header = request.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        UsernamePasswordAuthenticationToken authenticationToken = this.getAuthentication(request);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null) {
            String user = null;
            try {
                user = ((Claims)Jwts.parser().setSigningKey(InfusersUtility.getInstance().getJwttokensecret().getBytes()).parseClaimsJws(token.replace("Bearer", "")).getBody()).getSubject();
            }
            catch (Exception e) {
                this.log.error("AuthorizationFilter.getAuthentication() :: exception. " + e.getMessage());
            }
            if (user != null) {
                return new UsernamePasswordAuthenticationToken((Object)user, null, new ArrayList());
            }
        }
        return null;
    }
}

