/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets.gcp;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.infusers.core.secrets.SecretManager;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class GCPSecretManager
implements SecretManager {
    private Logger log = LogManager.getLogger(GCPSecretManager.class);
    @Value(value="${infusers.secretsmanager.gcp.projectdetails}")
    private String gcpProjectDetails;

    @Bean
    public SecretManagerServiceClient secretManagerServiceClient() {
        try {
            SecretManagerServiceClient client = SecretManagerServiceClient.create();
            return client;
        }
        catch (IOException e) {
            this.log.error("SecretManagerConfig.secretManagerServiceClient()-> Failed to create SecretManagerServiceClient, looks like this is NOT GCP environment?" + e.getMessage());
            return null;
        }
    }

    @Override
    public String getSecret(String region, String secretName) {
        String secretFullName = this.gcpProjectDetails + secretName + "/versions/1";
        try {
            SecretManagerServiceClient secretManagerServiceClient = this.secretManagerServiceClient();
            if (secretManagerServiceClient == null) {
                this.log.error("SecretsUtility.getGCPSecret()-> SecretManagerServiceClient is NULL, looks like this is NOT GCP environment?");
                return null;
            }
            SecretVersionName secretVersionName = SecretVersionName.parse((String)secretFullName);
            AccessSecretVersionResponse response = secretManagerServiceClient.accessSecretVersion(secretVersionName);
            String secretValue = response.getPayload().getData().toStringUtf8();
            this.log.warn("SecretsUtility.getGCPSecret()-> secretName = " + secretName + " :: secretFullName = " + secretFullName + " :: secretVersionName = " + secretVersionName + " :: secretValue = " + secretValue);
            return secretValue;
        }
        catch (Exception e) {
            this.log.error("SecretManagerConfig.getGCPSecret()" + e.getMessage() + " :: secretName = " + secretName + " :: secretFullName = " + secretFullName);
            return null;
        }
    }
}

