/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets;

import com.infusers.core.secrets.SecretManager;
import com.infusers.core.secrets.aws.AWSSecretManager;
import com.infusers.core.secrets.gcp.GCPSecretManager;
import com.infusers.core.secrets.local.DefaultSecretManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class SecretManagerConfig {
    private Logger log = LogManager.getLogger(SecretManagerConfig.class);

    @Bean
    @Profile(value={"aws"})
    public SecretManager awsSecretManager() {
        this.log.info("=========================================================");
        this.log.warn("SecretManagerConfig.awsSecretManager()--> Profile is AWS!");
        this.log.info("=========================================================");
        return new AWSSecretManager();
    }

    @Bean
    @Profile(value={"gcp"})
    public SecretManager gcpSecretManager() {
        this.log.info("=========================================================");
        this.log.warn("SecretManagerConfig.gcpSecretManager()--> Profile is GCP!");
        this.log.info("=========================================================");
        return new GCPSecretManager();
    }

    @Bean
    @Profile(value={"!aws && !gcp"})
    public SecretManager defaultSecretManager() {
        this.log.info("======================================================================");
        this.log.warn("SecretManagerConfig.defaultSecretManager()--> Profile is Local/Laptop!");
        this.log.info("======================================================================");
        return new DefaultSecretManager();
    }
}

