/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets;

import com.google.gson.Gson;
import com.infusers.core.secrets.SecretManager;
import com.infusers.core.secrets.dto.EmailSecrets;
import com.infusers.core.secrets.dto.OtherSecrets;
import com.infusers.core.util.InfusersUtility;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class CustomPropertiesListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private Logger log = LogManager.getLogger(CustomPropertiesListener.class);
    String emailSecretName = "infusers/email/configuration";
    String otherSecretName = "infusers/others";
    String rabbitMQSecretName = "infusers/prod/rabbitmq";
    public static final String PROPERTY_NAME_EMAIL_PASSWORD = "spring.mail.password";
    public static final String PROPERTY_NAME_EMAIL_USER_NAME = "spring.mail.username";
    public static final String PROPERTY_NAME_EMAIL_HOST = "spring.mail.host";
    public static final String PROPERTY_NAME_EMAIL_PORT = "spring.mail.port";
    public static final String PROPERTY_NAME_RABBIT_MQ_USER_NAME = "spring.rabbitmq.username";
    public static final String PROPERTY_NAME_RABBIT_MQ_PASSWORD = "spring.rabbitmq.password";
    private final SecretManager secretManager;
    private final ConfigurableEnvironment environment;

    public CustomPropertiesListener(SecretManager secretManager, ConfigurableEnvironment environment) {
        this.secretManager = secretManager;
        this.environment = environment;
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        boolean isActiveProfileDev = InfusersUtility.getInstance().isActiveProfileDevelopment((Environment)event.getApplicationContext().getEnvironment());
        if (!isActiveProfileDev) {
            this.loadEmailConfiguration(event);
            this.loadOtherConfiguration(event);
        } else {
            this.log.info("=================================================================================================");
            this.log.warn("PropertiesListener.onApplicationEvent() :: Email's NOT configured, Active Prfile is Development!!");
            this.log.info("=================================================================================================");
        }
    }

    private void loadOtherConfiguration(ApplicationPreparedEvent event) {
        if (this.secretManager == null) {
            this.log.info("=======================================================================================================================");
            this.log.error("PropertiesListener.loadOtherConfiguration() :: Something is seriously wrong. STOP STOP STOP!! Secrets Manager is NULL..");
            this.log.info("========================================================================================================================");
            throw new RuntimeException("PropertiesListener.loadOtherConfiguration() :: Something is seriously wrong. STOP STOP STOP!! Secrets Manager is NULL..");
        }
        Gson gson = new Gson();
        String secretsStr = this.secretManager.getSecret("us-east-1", this.otherSecretName);
        OtherSecrets secrets = (OtherSecrets)gson.fromJson(secretsStr, OtherSecrets.class);
        if (secrets == null) {
            this.log.error("PropertiesListener.loadOtherConfiguration() :: AwsOtherSecrets is NULL.");
            return;
        }
        this.log.warn("PropertiesListener.loadOtherConfiguration() :: AwsOtherSecrets are available.");
        double expiryHours = Double.parseDouble(secrets.getJwtTokenExpiryHours());
        if (expiryHours <= 0.0) {
            expiryHours = 2.0;
        }
        OtherSecrets.getInstance().setJwttokensecret(secrets.getJwttokensecret());
        OtherSecrets.getInstance().setJwtTokenExpiryHoursNumber(expiryHours);
        InfusersUtility.getInstance().setJWTTokenDynamicEnabled(true);
    }

    private void loadEmailConfiguration(ApplicationPreparedEvent event) {
        Gson gson = new Gson();
        String secretsStr = this.secretManager.getSecret("us-east-1", this.emailSecretName);
        EmailSecrets secrets = (EmailSecrets)gson.fromJson(secretsStr, EmailSecrets.class);
        if (secrets == null) {
            this.log.error("PropertiesListener.loadEmailConfiguration() :: AwsEmailSecrets is NULL.");
            return;
        }
        this.log.warn("PropertiesListener.loadEmailConfiguration() :: AwsEmailSecrets are available. Host = " + secrets.getHost() + " :: Port = " + secrets.getPort());
        Properties props = new Properties();
        props.put(PROPERTY_NAME_EMAIL_PASSWORD, secrets.getPassword());
        props.put(PROPERTY_NAME_EMAIL_HOST, secrets.getHost());
        props.put(PROPERTY_NAME_EMAIL_PORT, secrets.getPort());
        props.put(PROPERTY_NAME_EMAIL_USER_NAME, secrets.getUsername());
        this.environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("aws.secret.manager", props));
        InfusersUtility.getInstance().setEmailConfigrued(true);
    }
}

