/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.secrets;

import com.google.gson.Gson;
import com.infusers.core.secrets.SecretManager;
import com.infusers.core.secrets.dto.DBSecrets;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppConfig {
    @Value(value="${spring.secretsmanager.db.details}")
    String secretNameDB;
    @Value(value="${spring.aws.secretsmanager.region}")
    String region;
    @Value(value="${spring.datasource.url}")
    String url;
    @Value(value="${spring.datasource.username}")
    String userName;
    @Value(value="${spring.datasource.password}")
    String password;
    private Logger log = LogManager.getLogger(AppConfig.class);
    @Autowired
    private SecretManager secretManager;

    public String getSecretValue(String region, String secretName) {
        return this.secretManager.getSecret(region, secretName);
    }

    @Bean
    public DataSource dataSource() {
        DBSecrets secrets = this.getDBSecrets();
        if (secrets != null) {
            this.log.warn("AppConfig.dataSource() Aws/GCP secrets are available.");
            String host = secrets.getHost();
            if (host == null | host.trim().length() == 0) {
                host = this.url;
            }
            this.log.warn("AppConfig.dataSource() Aws/GCP secrets are available. " + secrets + " :: url = " + this.url + " :: host = " + host);
            return DataSourceBuilder.create().url("jdbc:" + secrets.getEngine() + "://" + host + ":" + secrets.getPort() + "/" + secrets.getDbname()).username(secrets.getUsername()).password(secrets.getPassword()).build();
        }
        this.log.info("==============================================================================");
        this.log.warn("AppConfig.dataSource() Secrets are NOT available, falling back to Inmemory DB.");
        this.log.info("==============================================================================");
        return DataSourceBuilder.create().url(this.url).username(this.userName).password(this.password).build();
    }

    private DBSecrets getDBSecrets() {
        String secretsStr = this.secretManager.getSecret(this.region, this.secretNameDB);
        Gson gson = new Gson();
        return (DBSecrets)gson.fromJson(secretsStr, DBSecrets.class);
    }
}

